/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.thirdparty.ae2.AE2Integration;
import me.desht.pneumaticcraft.common.thirdparty.ae2.AE2RequesterIntegration;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class LogisticsRequesterEntity
extends AbstractLogisticsFrameEntity
implements ISpecificRequester,
IProvidingInventoryListener {
    private static final EntityDataAccessor<Boolean> AE2_ENABLED = SynchedEntityData.defineId(LogisticsRequesterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String NBT_AE2_INTEGRATION = "AE2_Integration";
    private int minItems = 1;
    private int minFluid = 1;
    private final AE2RequesterIntegration ae2requester = null;

    public LogisticsRequesterEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(AE2_ENABLED, (Object)false);
        if (AE2Integration.isAvailable()) {
            // empty if block
        }
    }

    @Override
    public int getColor() {
        return -16776961;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.MODEL_LOGISTICS_FRAME_REQUESTER;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    protected MenuType<?> getContainerType() {
        return ModMenuTypes.LOGISTICS_FRAME_REQUESTER.get();
    }

    @Override
    public int getMinItemOrderSize() {
        return this.minItems;
    }

    @Override
    public void setMinItemOrderSize(int minItems) {
        this.minItems = minItems;
    }

    @Override
    public int getMinFluidOrderSize() {
        return this.minFluid;
    }

    @Override
    public void setMinFluidOrderSize(int minFluid) {
        this.minFluid = minFluid;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (AE2Integration.isAvailable()) {
            this.setAE2enabled(tag.getBoolean(NBT_AE2_INTEGRATION));
        }
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag = super.serializeNBT(tag, provider);
        if (AE2Integration.isAvailable()) {
            tag.putBoolean(NBT_AE2_INTEGRATION, this.isAE2enabled());
        }
        return tag;
    }

    @Override
    public boolean canFilterStack() {
        return true;
    }

    @Override
    public boolean supportsBlacklisting() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void notify(IProvidingInventoryListener.BlockEntityAndFace teAndFace) {
    }

    @Override
    protected void doExtraCleanupTasks(boolean removingSemiblock) {
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        super.handleGUIButtonPress(tag, shiftHeld, player);
    }

    @Override
    public int amountRequested(ItemStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            return IOHelper.getInventoryForBlock(this.getCachedTileEntity(), this.getSide()).map(itemHandler -> {
                int count = 0;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack s = itemHandler.getStackInSlot(i);
                    if (s.isEmpty() || !this.getItemFilterHandler().matchOneItem(stack, s)) continue;
                    count += s.getCount();
                }
                return Math.max(0, Math.min(stack.getCount(), totalRequestingAmount - (count += this.getIncomingItems(stack))));
            }).orElse(0);
        }
        return 0;
    }

    @Override
    public int amountRequested(FluidStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            return IOHelper.getFluidHandlerForBlock(this.getCachedTileEntity(), this.getSide()).map(fluidHandler -> {
                int count = 0;
                for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                    FluidStack contents = fluidHandler.getFluidInTank(i);
                    if (contents.getFluid() != stack.getFluid()) continue;
                    count += contents.getAmount();
                }
                return Math.max(0, Math.min(stack.getAmount(), totalRequestingAmount - (count += this.getIncomingFluid(stack.getFluid()))));
            }).orElse(0);
        }
        return 0;
    }

    private int getTotalRequestedAmount(ItemStack stack) {
        return this.getItemFilterHandler().getMatchedCount(stack);
    }

    private int getTotalRequestedAmount(FluidStack stack) {
        int requesting = 0;
        for (int i = 0; i < 9; ++i) {
            FluidStack requestingStack = this.getFluidFilter(i);
            if (requestingStack == null || requestingStack.getFluid() != stack.getFluid()) continue;
            requesting += requestingStack.getAmount();
        }
        return requesting;
    }

    private void setAE2enabled(boolean enabled) {
        this.getEntityData().set(AE2_ENABLED, (Object)enabled);
    }

    public boolean isAE2enabled() {
        return AE2Integration.isAvailable() && (Boolean)this.getEntityData().get(AE2_ENABLED) != false;
    }
}

