/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.AbstractPersistentEntityHack;
import me.desht.pneumaticcraft.mixin.accessors.ShulkerAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.jetbrains.annotations.NotNull;

public class HackableShulker
extends AbstractPersistentEntityHack<Shulker> {
    private static final ResourceLocation ID = PneumaticRegistry.RL("shulker");

    public HackableShulker() {
        super(AbstractPersistentEntityHack.StockHackTypes.NEUTRALIZE);
    }

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    @NotNull
    public Class<Shulker> getHackableClass() {
        return Shulker.class;
    }

    @Override
    public boolean afterHackTick(Shulker entity) {
        if (entity.level().random.nextInt(5) < 4) {
            ((ShulkerAccess)entity).callSetRawPeekAmount(100);
        }
        return true;
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onBullet(EntityJoinLevelEvent event) {
            Shulker shulker;
            ShulkerBullet b;
            Entity entity = event.getEntity();
            if (entity instanceof ShulkerBullet && (entity = (b = (ShulkerBullet)entity).getOwner()) instanceof Shulker && AbstractPersistentEntityHack.hasPersistentHack(shulker = (Shulker)entity, HackableShulker.class)) {
                event.setCanceled(true);
            }
        }
    }
}

