/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import java.util.Optional;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.HeatExtractionTracker;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourLiquid;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public abstract class HeatBehaviourTransition
extends HeatBehaviourLiquid {
    private static final Vector3f VEC3F_101 = new Vector3f(1.0f, 0.0f, 1.0f);
    private double maxExchangedHeat;
    private double blockTemp = -1.0;
    private IHeatExchangerLogic logic;
    private HeatExtractionTracker tracker;

    @Override
    public boolean isApplicable() {
        this.logic = HeatExchangerManager.getInstance().getLogic(this.getWorld(), this.getPos(), null).orElse(null);
        return this.logic != null;
    }

    @Override
    public HeatBehaviour initialize(IHeatExchangerLogic connectedHeatLogic, Level world, BlockPos pos, Direction direction) {
        super.initialize(connectedHeatLogic, world, pos, direction);
        this.tracker = HeatExtractionTracker.getInstance(this.getWorld());
        return this;
    }

    protected abstract int getMaxExchangedHeat();

    protected boolean transformBlockHot() {
        return false;
    }

    protected boolean transformBlockCold() {
        return false;
    }

    @Override
    public void tick() {
        double extractedHeat;
        if (this.blockTemp == -1.0 && this.logic != null) {
            this.blockTemp = this.logic.getTemperature();
            this.maxExchangedHeat = (double)this.getMaxExchangedHeat() * (this.logic.getThermalResistance() + this.getHeatExchanger().getThermalResistance());
        }
        if ((extractedHeat = this.tracker.getHeatExtracted(this.getPos())) < Math.abs(this.maxExchangedHeat)) {
            double toExtract = this.blockTemp - this.getHeatExchanger().getTemperature();
            this.tracker.extractHeat(this.getPos(), toExtract);
            extractedHeat += toExtract;
        }
        if (extractedHeat >= this.maxExchangedHeat) {
            if (this.transformBlockCold()) {
                this.tracker.extractHeat(this.getPos(), -this.maxExchangedHeat);
            }
        } else if (extractedHeat <= -this.maxExchangedHeat && this.transformBlockHot()) {
            this.tracker.extractHeat(this.getPos(), this.maxExchangedHeat);
        }
    }

    void onTransition(BlockPos pos) {
        this.getWorld().playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.5f, 2.6f + (this.getWorld().random.nextFloat() - this.getWorld().random.nextFloat()) * 0.8f);
        NetworkHandler.sendToAllTracking(new PacketSpawnParticle((ParticleOptions)ParticleTypes.SMOKE, new Vector3f((float)pos.getX(), (float)(pos.getY() + 1), (float)pos.getZ()), PneumaticCraftUtils.VEC3F_ZERO, 8, Optional.of(VEC3F_101)), this.getWorld(), pos);
    }

    public double getExtractionProgress() {
        return this.maxExchangedHeat == 0.0 ? 0.0 : this.tracker.getHeatExtracted(this.getPos()) / this.maxExchangedHeat;
    }
}

