/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;

public record PacketSpawnParticle(ParticleOptions particle, Vector3f pos, Vector3f speed, int numParticles, Optional<Vector3f> randomOffset) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSpawnParticle> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("spawn_particle"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSpawnParticle> STREAM_CODEC = StreamCodec.composite((StreamCodec)ParticleTypes.STREAM_CODEC, PacketSpawnParticle::particle, (StreamCodec)ByteBufCodecs.VECTOR3F, PacketSpawnParticle::pos, (StreamCodec)ByteBufCodecs.VECTOR3F, PacketSpawnParticle::speed, (StreamCodec)ByteBufCodecs.VAR_INT, PacketSpawnParticle::numParticles, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VECTOR3F), PacketSpawnParticle::randomOffset, PacketSpawnParticle::new);

    public static PacketSpawnParticle oneParticle(ParticleOptions particle, Vector3f pos, Vector3f speed) {
        return new PacketSpawnParticle(particle, pos, speed, 1, Optional.empty());
    }

    public CustomPacketPayload.Type<PacketSpawnParticle> type() {
        return TYPE;
    }

    public static void handle(PacketSpawnParticle message, IPayloadContext ctx) {
        Level world = ClientUtils.getClientLevel();
        int numParticles = message.numParticles();
        Vector3f r = message.randomOffset.orElse(new Vector3f(0.0f, 0.0f, 0.0f));
        for (int i = 0; i < numParticles; ++i) {
            double x1 = (double)message.pos.x + (numParticles == 1 ? 0.0 : world.random.nextDouble() * (double)r.x);
            double y1 = (double)message.pos.y + (numParticles == 1 ? 0.0 : world.random.nextDouble() * (double)r.y);
            double z1 = (double)message.pos.z + (numParticles == 1 ? 0.0 : world.random.nextDouble() * (double)r.z);
            world.addParticle(message.particle(), x1, y1, z1, (double)message.speed.x, (double)message.speed.y, (double)message.speed.z);
        }
    }
}

