/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.OfferType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSyncAmadronOffers(Collection<AmadronOffer> activeOffers, boolean notifyPlayer) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSyncAmadronOffers> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("sync_amadron_offers"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSyncAmadronOffers> STREAM_CODEC = StreamCodec.of(PacketSyncAmadronOffers::toNetwork, PacketSyncAmadronOffers::fromNetwork);

    public static PacketSyncAmadronOffers createRequest() {
        return new PacketSyncAmadronOffers(List.of(), false);
    }

    public static PacketSyncAmadronOffers create(boolean notifyPlayer) {
        return new PacketSyncAmadronOffers(AmadronOfferManager.getInstance().getActiveOffers(), notifyPlayer);
    }

    private static PacketSyncAmadronOffers fromNetwork(RegistryFriendlyByteBuf buf) {
        boolean notifyPlayer = buf.readBoolean();
        ArrayList<AmadronOffer> activeOffers = new ArrayList<AmadronOffer>();
        int offerCount = buf.readVarInt();
        for (int i = 0; i < offerCount; ++i) {
            OfferType type = (OfferType)buf.readEnum(OfferType.class);
            type.read(buf).ifPresent(activeOffers::add);
        }
        return new PacketSyncAmadronOffers(activeOffers, notifyPlayer);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buf, PacketSyncAmadronOffers message) {
        buf.writeBoolean(message.notifyPlayer);
        buf.writeVarInt(message.activeOffers.size());
        for (AmadronOffer offer : message.activeOffers) {
            buf.writeEnum((Enum)offer.getOfferType());
            offer.getOfferType().write(buf, offer);
        }
    }

    public CustomPacketPayload.Type<PacketSyncAmadronOffers> type() {
        return TYPE;
    }

    public static void handle(PacketSyncAmadronOffers message, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            AmadronOfferManager.getInstance().syncOffers(message.activeOffers(), message.notifyPlayer());
        } else {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHandler.sendNonLocal(sp, PacketSyncAmadronOffers.create(false));
            }
        }
    }
}

