/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.TubeModulePacket;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public record PacketSyncRedstoneModuleToServer(TubeModulePacket.ModuleLocator locator, RedstoneModule.Operation op, byte ourColor, byte otherColor, int constantVal, boolean invert, RedstoneModule.EnumRedstoneDirection redstoneDirection, boolean comparatorInput) implements TubeModulePacket<RedstoneModule>
{
    public static final CustomPacketPayload.Type<PacketSyncRedstoneModuleToServer> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("sync_redstone_module_to_server"));
    public static final StreamCodec<FriendlyByteBuf, PacketSyncRedstoneModuleToServer> STREAM_CODEC = StreamCodec.of(PacketSyncRedstoneModuleToServer::toNetwork, PacketSyncRedstoneModuleToServer::fromNetwork);

    public static PacketSyncRedstoneModuleToServer forModule(RedstoneModule module) {
        return new PacketSyncRedstoneModuleToServer(TubeModulePacket.ModuleLocator.forModule(module), module.getOperation(), (byte)module.getColorChannel(), (byte)module.getOtherColor(), module.getConstantVal(), module.isInverted(), module.getRedstoneDirection(), module.isComparatorInput());
    }

    public static PacketSyncRedstoneModuleToServer fromNetwork(FriendlyByteBuf buffer) {
        TubeModulePacket.ModuleLocator loc = (TubeModulePacket.ModuleLocator)TubeModulePacket.ModuleLocator.STREAM_CODEC.decode((Object)buffer);
        RedstoneModule.EnumRedstoneDirection redstoneDir = (RedstoneModule.EnumRedstoneDirection)buffer.readEnum(RedstoneModule.EnumRedstoneDirection.class);
        byte ourColor = buffer.readByte();
        if (redstoneDir.isInput()) {
            return new PacketSyncRedstoneModuleToServer(loc, RedstoneModule.Operation.PASSTHROUGH, ourColor, 0, 0, false, RedstoneModule.EnumRedstoneDirection.INPUT, buffer.readBoolean());
        }
        return new PacketSyncRedstoneModuleToServer(loc, (RedstoneModule.Operation)buffer.readEnum(RedstoneModule.Operation.class), ourColor, buffer.readByte(), buffer.readVarInt(), buffer.readBoolean(), RedstoneModule.EnumRedstoneDirection.OUTPUT, false);
    }

    public static void toNetwork(FriendlyByteBuf buf, PacketSyncRedstoneModuleToServer message) {
        TubeModulePacket.ModuleLocator.STREAM_CODEC.encode((Object)buf, (Object)message.locator);
        buf.writeEnum((Enum)message.redstoneDirection);
        buf.writeByte(message.ourColor);
        if (message.redstoneDirection.isInput()) {
            buf.writeBoolean(message.comparatorInput);
        } else {
            buf.writeEnum((Enum)message.op);
            buf.writeByte(message.otherColor);
            buf.writeVarInt(message.constantVal);
            buf.writeBoolean(message.invert);
        }
    }

    public CustomPacketPayload.Type<PacketSyncRedstoneModuleToServer> type() {
        return TYPE;
    }

    @Override
    public void onModuleUpdate(RedstoneModule module, Player player) {
        if (PneumaticCraftUtils.canPlayerReach(player, module.getTube().getBlockPos())) {
            module.setRedstoneDirection(this.redstoneDirection);
            module.setColorChannel(this.ourColor);
            if (this.redstoneDirection.isInput()) {
                module.setComparatorInput(this.comparatorInput);
            } else {
                module.setInverted(this.invert);
                module.setOperation(this.op, this.otherColor, this.constantVal);
            }
            module.updateNeighbors();
            module.updateInputLevel();
        }
    }
}

