/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateMicromissileSettings(MicromissilesItem.Settings settings, boolean saveDefault, InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdateMicromissileSettings> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("packetupdatemicromissilesettings"));
    public static final StreamCodec<FriendlyByteBuf, PacketUpdateMicromissileSettings> STREAM_CODEC = StreamCodec.composite(MicromissilesItem.Settings.STREAM_CODEC, PacketUpdateMicromissileSettings::settings, (StreamCodec)ByteBufCodecs.BOOL, PacketUpdateMicromissileSettings::saveDefault, (StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), PacketUpdateMicromissileSettings::hand, PacketUpdateMicromissileSettings::new);

    public CustomPacketPayload.Type<PacketUpdateMicromissileSettings> type() {
        return TYPE;
    }

    public static void handle(PacketUpdateMicromissileSettings message, IPayloadContext ctx) {
        Player player = ctx.player();
        ItemStack stack = player.getItemInHand(message.hand());
        if (!stack.isEmpty()) {
            message.applySettings(player, stack);
        } else {
            Log.warning("Received PacketUpdateMicromissileSettings but player does not hold a Micromissile? " + String.valueOf(player.getName()), new Object[0]);
        }
    }

    private void applySettings(Player player, ItemStack stack) {
        stack.set(ModDataComponents.MICROMISSILE_SETTINGS, (Object)this.settings);
        if (this.saveDefault) {
            MicromissileDefaults.INSTANCE.setDefaults(player, this.settings);
            MicromissileDefaults.INSTANCE.tryWriteToFile();
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.CHIRP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

