/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import com.mojang.serialization.MapCodec;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.recipes.special.WrappedShapedRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class ShapedPressurizableRecipe
extends WrappedShapedRecipe {
    public ShapedPressurizableRecipe(ShapedRecipe wrapped) {
        super(wrapped);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ItemStack newOutput = this.getResultItem(registryAccess).copy();
        IOHelper.getCap(newOutput, PNCCapabilities.AIR_HANDLER_ITEM).ifPresent(outputHandler -> {
            int totalAir = 0;
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack stack = inv.getItem(i);
                totalAir += IOHelper.getCap(stack, PNCCapabilities.AIR_HANDLER_ITEM).map(IAirHandler::getAir).orElse(0).intValue();
            }
            outputHandler.addAir(totalAir);
        });
        return newOutput;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.CRAFTING_SHAPED_PRESSURIZABLE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedPressurizableRecipe> {
        public static final MapCodec<ShapedPressurizableRecipe> CODEC = ShapedRecipe.Serializer.CODEC.xmap(ShapedPressurizableRecipe::new, WrappedShapedRecipe::wrapped);
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedPressurizableRecipe> STREAM_CODEC = ShapedRecipe.Serializer.STREAM_CODEC.map(ShapedPressurizableRecipe::new, WrappedShapedRecipe::wrapped);

        public MapCodec<ShapedPressurizableRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedPressurizableRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

