/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.registry;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModVillagers {
    public static final DeferredRegister<PoiType> POI = DeferredRegister.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (String)"pneumaticcraft");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"pneumaticcraft");
    public static final DeferredHolder<PoiType, PoiType> MECHANIC_POI = POI.register("mechanic", () -> new PoiType(ModVillagers.getAllStates((Block)ModBlocks.CHARGING_STATION.get()), 1, 1));
    public static final Supplier<VillagerProfession> MECHANIC = ModVillagers.registerProfession("mechanic", MECHANIC_POI, ModSounds.SHORT_HISS);

    private static Supplier<VillagerProfession> registerProfession(String name, DeferredHolder<PoiType, PoiType> poiType, Supplier<SoundEvent> sound) {
        return PROFESSIONS.register(name, () -> ModVillagers.register(PneumaticRegistry.RL(name), poiType, (SoundEvent)sound.get()));
    }

    private static VillagerProfession register(ResourceLocation name, DeferredHolder<PoiType, PoiType> poi, SoundEvent sound) {
        ResourceKey poiName = Objects.requireNonNull(poi.getKey());
        return new VillagerProfession(name.toString(), holder -> holder.is(poiName), holder -> holder.is(poiName), ImmutableSet.of(), ImmutableSet.of(), sound);
    }

    private static Set<BlockState> getAllStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates());
    }
}

