/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.cofhcore;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.ItemVolumeModifier;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class HoldingEnchantableProvider {
    static Holder<Enchantment> holdingEnchantment = null;
    private static final boolean holdingEnabled = (Double)ConfigHelper.common().integration.cofhHoldingMultiplier.get() > 0.0;

    static void registerVolumeModifier() {
        holdingEnchantment = null;
        if (holdingEnchantment != null && holdingEnabled) {
            PneumaticRegistry.getInstance().getItemRegistry().registerPneumaticVolumeModifier(new C0FHVolumeModifier(holdingEnchantment));
        }
    }

    public record C0FHVolumeModifier(Holder<Enchantment> holding) implements ItemVolumeModifier
    {
        @Override
        public int getNewVolume(ItemStack stack, int oldVolume) {
            return (int)Math.ceil((double)oldVolume * ((double)(1 + stack.getEnchantmentLevel(this.holding)) * (Double)ConfigHelper.common().integration.cofhHoldingMultiplier.get()));
        }

        @Override
        public void addInfo(ItemStack stack, List<Component> text) {
            int count = stack.getEnchantmentLevel(this.holding);
            if (count > 0) {
                text.add((Component)Component.literal((String)"\u25b6 ").append(Enchantment.getFullname(this.holding, (int)count)));
            }
        }
    }
}

