/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computer_common;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICheckLineOfSight;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IGotoWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemDropper;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemPickupWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.IRedstoneEmissionWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IRenamingWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISignEditWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IStandbyWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ITextWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.recipes.VanillaRecipeCache;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.DroneAICC;
import me.desht.pneumaticcraft.common.util.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.util.legacyconv.ProgWidgetLegacyConv;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class ProgWidgetCC
extends ProgWidgetInventoryBase
implements IBlockOrdered,
IGotoWidget,
IItemPickupWidget,
IEntityProvider,
ITextWidget,
ICondition,
IItemDropper,
ILiquidFiltered,
IRedstoneEmissionWidget,
IRenamingWidget,
ICraftingWidget,
IMaxActions,
IBlockRightClicker,
ILiquidExport,
ISignEditWidget,
IToolUser,
ICheckLineOfSight,
IStandbyWidget {
    public static final MapCodec<ProgWidgetCC> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetCC.invParts(builder).apply((Applicative)builder, ProgWidgetCC::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetCC> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetCC::new);
    private IBlockOrdered.Ordering order = IBlockOrdered.Ordering.CLOSEST;
    private boolean[] sides = new boolean[6];
    private final Set<BlockPos> area = new HashSet<BlockPos>();
    private final List<ProgWidgetItemFilter> itemWhitelist = new ArrayList<ProgWidgetItemFilter>();
    private final List<ProgWidgetItemFilter> itemBlacklist = new ArrayList<ProgWidgetItemFilter>();
    private StringFilterEntitySelector whitelistFilter;
    private StringFilterEntitySelector blacklistFilter;
    private int emittingRedstone;
    private boolean dropItemStraight;
    private boolean useCount;
    private int count;
    private boolean useMaxActions;
    private int maxActions;
    private boolean isAndFunction;
    private ICondition.Operator operator;
    private final List<ProgWidgetLiquidFilter> liquidBlacklist = new ArrayList<ProgWidgetLiquidFilter>();
    private final List<ProgWidgetLiquidFilter> liquidWhitelist = new ArrayList<ProgWidgetLiquidFilter>();
    private String renamingName;
    private ItemStack[] craftingGrid = new ItemStack[9];
    private boolean sneaking;
    private boolean placeFluidBlocks;
    private boolean requiresTool;
    String[] signText = new String[0];
    private boolean pickupDelay;
    private IBlockRightClicker.RightClickType clickType = IBlockRightClicker.RightClickType.CLICK_ITEM;
    private String measureVar = "";
    private boolean canSteal;
    private boolean checkSight;
    private boolean signBackSide;
    private boolean allowStandbyPickup;

    private ProgWidgetCC(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields invBaseFields) {
        super(pos, invBaseFields);
    }

    public ProgWidgetCC() {
        this(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetCC(this.getPosition(), this.invBaseFields());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.PURPLE;
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.COMPUTER_CONTROL.get();
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && ThirdPartyManager.instance().isModTypeLoaded(ThirdPartyManager.ModType.COMPUTER);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CC;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAICC((DroneEntity)drone, (ProgWidgetCC)widget, false);
    }

    @Override
    public Goal getWidgetTargetAI(IDrone drone, IProgWidget widget) {
        return new DroneAICC((DroneEntity)drone, (ProgWidgetCC)widget, true);
    }

    Set<BlockPos> getInterfaceArea() {
        HashSet<BlockPos> area = new HashSet<BlockPos>();
        ProgWidgetCC.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[1]);
        return area;
    }

    @Override
    public void setOrder(IBlockOrdered.Ordering order) {
        this.order = order;
    }

    @Override
    public IBlockOrdered.Ordering getOrder() {
        return this.order;
    }

    String[] getAreaTypes() {
        String[] areaTypes = new String[EnumOldAreaType.values().length];
        Arrays.setAll(areaTypes, i -> EnumOldAreaType.values()[i].toString());
        return areaTypes;
    }

    public synchronized void addArea(int x, int y, int z) {
        this.area.add(new BlockPos(x, y, z));
        this.invalidateAreaCache();
    }

    public synchronized void addArea(int x1, int y1, int z1, int x2, int y2, int z2, String areaType) throws IllegalArgumentException {
        this.area.addAll(this.getArea(x1, y1, z1, x2, y2, z2, areaType));
        this.invalidateAreaCache();
    }

    synchronized void removeArea(int x, int y, int z) {
        this.area.remove(new BlockPos(x, y, z));
        this.invalidateAreaCache();
    }

    synchronized void removeArea(int x1, int y1, int z1, int x2, int y2, int z2, String areaType) throws IllegalArgumentException {
        this.area.removeAll(this.getArea(x1, y1, z1, x2, y2, z2, areaType));
        this.invalidateAreaCache();
    }

    synchronized void clearArea() {
        this.area.clear();
        this.invalidateAreaCache();
    }

    @Override
    public synchronized Set<BlockPos> getArea(Set<BlockPos> area) {
        area.addAll(this.area);
        return area;
    }

    private Set<BlockPos> getArea(int x1, int y1, int z1, int x2, int y2, int z2, String areaType) throws IllegalArgumentException {
        EnumOldAreaType type = EnumOldAreaType.byName(areaType);
        if (type == null) {
            throw new IllegalArgumentException("Unknown area type: '" + areaType + "'. Use `getAreaTypes()` to list accepted values.");
        }
        ProgWidgetArea helperWidget = new ProgWidgetArea();
        helperWidget.setPos(0, new BlockPos(x1, y1, z1));
        helperWidget.setPos(1, new BlockPos(x2, y2, z2));
        helperWidget.setAreaType(ProgWidgetLegacyConv.LegacyAreaWidgetConverter.convertFromLegacyFormat(type, 0));
        HashSet<BlockPos> a = new HashSet<BlockPos>();
        helperWidget.getArea(a);
        return a;
    }

    @Override
    public synchronized boolean isItemValidForFilters(ItemStack item, BlockState blockMetadata) {
        return ProgWidgetItemFilter.isItemValidForFilters(item, this.itemWhitelist, this.itemBlacklist, blockMetadata);
    }

    @Override
    public boolean isItemFilterEmpty() {
        return this.itemWhitelist.isEmpty() && this.itemBlacklist.isEmpty();
    }

    synchronized void addWhitelistItemFilter(String itemName, boolean useNBT, boolean useModSimilarity) throws IllegalArgumentException {
        this.itemWhitelist.add(this.getItemFilter(itemName, useNBT, useModSimilarity));
    }

    synchronized void addBlacklistItemFilter(String itemName, boolean useNBT, boolean useModSimilarity) throws IllegalArgumentException {
        this.itemBlacklist.add(this.getItemFilter(itemName, useNBT, useModSimilarity));
    }

    synchronized void clearItemWhitelist() {
        this.itemWhitelist.clear();
    }

    synchronized void clearItemBlacklist() {
        this.itemBlacklist.clear();
    }

    private ProgWidgetItemFilter getItemFilter(String itemName, boolean matchComponents, boolean matchMod) throws IllegalArgumentException {
        if (!itemName.contains(":")) {
            throw new IllegalArgumentException("Item/Block name doesn't contain a ':'!");
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName));
        if (item == Items.AIR) {
            throw new IllegalArgumentException("Item not found for the name \"" + itemName + "\"!");
        }
        ProgWidgetItemFilter itemFilter = new ProgWidgetItemFilter();
        itemFilter.setFilter(new ItemStack((ItemLike)item));
        itemFilter.setMatchComponents(matchComponents);
        itemFilter.setMatchMod(matchMod);
        return itemFilter;
    }

    synchronized void addWhitelistText(String text) {
        if (this.whitelistFilter == null) {
            this.whitelistFilter = new StringFilterEntitySelector();
        }
        this.whitelistFilter.addEntry(text);
    }

    synchronized void addBlacklistText(String text) {
        if (this.blacklistFilter == null) {
            this.blacklistFilter = new StringFilterEntitySelector();
        }
        this.blacklistFilter.addEntry(text);
    }

    synchronized void clearWhitelistText() {
        this.whitelistFilter = null;
    }

    synchronized void clearBlacklistText() {
        this.blacklistFilter = null;
    }

    @Override
    public synchronized List<Entity> getValidEntities(Level world) {
        return ProgWidgetAreaItemBase.getEntitiesInArea(this.getEntityAreaWidget(), null, world, (Predicate<? super Entity>)((Object)this.whitelistFilter), (Predicate<? super Entity>)((Object)this.blacklistFilter));
    }

    private ProgWidgetArea getEntityAreaWidget() {
        ProgWidgetArea widget = new ProgWidgetArea();
        widget.setPos(0, this.getMinPos());
        widget.setPos(1, this.getMaxPos());
        return widget;
    }

    @Override
    public synchronized List<Entity> getEntitiesInArea(Level world, Predicate<? super Entity> filter) {
        return ProgWidgetAreaItemBase.getEntitiesInArea(this.getEntityAreaWidget(), null, world, filter, null);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        return !(this.whitelistFilter != null && !this.whitelistFilter.test(entity) || this.blacklistFilter != null && this.blacklistFilter.test(entity));
    }

    private BlockPos getMinPos() {
        int x = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        int z = Integer.MAX_VALUE;
        for (BlockPos p : this.area) {
            x = Math.min(p.getX(), x);
            y = Math.min(p.getY(), y);
            z = Math.min(p.getZ(), z);
        }
        return new BlockPos(x, y, z);
    }

    private BlockPos getMaxPos() {
        int x = Integer.MIN_VALUE;
        int y = Integer.MIN_VALUE;
        int z = Integer.MIN_VALUE;
        for (BlockPos p : this.area) {
            x = Math.max(p.getX(), x);
            y = Math.max(p.getY(), y);
            z = Math.max(p.getZ(), z);
        }
        return new BlockPos(x, y, z);
    }

    @Override
    public boolean doneWhenDeparting() {
        return false;
    }

    @Override
    public void setDoneWhenDeparting(boolean bool) {
    }

    @Override
    public synchronized void setSides(boolean[] sides) {
        this.sides = sides;
    }

    @Override
    public synchronized boolean[] getSides() {
        return this.sides;
    }

    void setEmittingRedstone(int redstone) {
        this.emittingRedstone = redstone;
    }

    @Override
    public int getEmittingRedstone() {
        return this.emittingRedstone;
    }

    synchronized void addWhitelistLiquidFilter(String fluidName) throws IllegalArgumentException {
        this.liquidWhitelist.add(this.getFilterForArgs(fluidName));
    }

    synchronized void addBlacklistLiquidFilter(String fluidName) throws IllegalArgumentException {
        this.liquidBlacklist.add(this.getFilterForArgs(fluidName));
    }

    synchronized void clearLiquidWhitelist() {
        this.liquidWhitelist.clear();
    }

    synchronized void clearLiquidBlacklist() {
        this.liquidBlacklist.clear();
    }

    private ProgWidgetLiquidFilter getFilterForArgs(String fluidName) throws IllegalArgumentException {
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fluidName));
        if (fluid == Fluids.EMPTY) {
            throw new IllegalArgumentException("Can't find fluid for the name \"" + fluidName + "\"!");
        }
        return ProgWidgetLiquidFilter.withFilter(fluid);
    }

    @Override
    public synchronized boolean isFluidValid(Fluid fluid) {
        return ProgWidgetLiquidFilter.isLiquidValid(fluid, this.liquidWhitelist, this.liquidBlacklist);
    }

    @Override
    public boolean dropStraight() {
        return this.dropItemStraight;
    }

    @Override
    public void setDropStraight(boolean dropStraight) {
        this.dropItemStraight = true;
    }

    @Override
    public boolean hasPickupDelay() {
        return this.pickupDelay;
    }

    @Override
    public void setPickupDelay(boolean pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public boolean isAndFunction() {
        return this.isAndFunction;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.isAndFunction = isAndFunction;
    }

    @Override
    public int getRequiredCount() {
        return this.count;
    }

    @Override
    public void setRequiredCount(int count) {
        this.count = count;
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public String getMeasureVar() {
        return this.measureVar;
    }

    @Override
    public void setMeasureVar(String var) {
        this.measureVar = var;
    }

    public synchronized void setOperator(String operator) throws IllegalArgumentException {
        for (ICondition.Operator op : ICondition.Operator.values()) {
            if (!op.toString().equals(operator)) continue;
            this.setOperator(op);
            return;
        }
        throw new IllegalArgumentException("Invalid operator: '" + operator + "'. Valid operators are: '<=', '=', '>='");
    }

    @Override
    public boolean evaluate(IDrone drone, IProgWidget widget) {
        return false;
    }

    void setNewName(String name) {
        this.renamingName = name;
    }

    @Override
    public String getNewName() {
        return this.renamingName;
    }

    void setCraftingGrid(String[] stackStrings) {
        Object[] grid = new ItemStack[9];
        Arrays.fill(grid, ItemStack.EMPTY);
        for (int i = 0; i < 9; ++i) {
            if (stackStrings[i] == null) continue;
            grid[i] = this.getItemFilter(stackStrings[i], false, false).getFilter();
        }
        this.craftingGrid = grid;
    }

    @Override
    public CraftingInput getCraftingGrid() {
        return CraftingInput.of((int)3, (int)3, List.of(this.craftingGrid));
    }

    @Override
    public Optional<CraftingRecipe> getRecipe(Level world, CraftingInput grid) {
        return VanillaRecipeCache.CRAFTING.getCachedRecipe(world, grid);
    }

    @Override
    public void setMaxActions(int maxActions) {
        this.maxActions = maxActions;
    }

    @Override
    public int getMaxActions() {
        return this.maxActions;
    }

    @Override
    public void setUseMaxActions(boolean useMaxActions) {
        this.useMaxActions = useMaxActions;
    }

    @Override
    public boolean useMaxActions() {
        return this.useMaxActions;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public IBlockRightClicker.RightClickType getClickType() {
        return this.clickType;
    }

    public void setClickType(IBlockRightClicker.RightClickType clickType) {
        this.clickType = clickType;
    }

    @Override
    public void setPlaceFluidBlocks(boolean placeFluidBlocks) {
        this.placeFluidBlocks = placeFluidBlocks;
    }

    @Override
    public boolean isPlacingFluidBlocks() {
        return this.placeFluidBlocks;
    }

    @Override
    public String[] getLines() {
        return this.signText;
    }

    @Override
    public boolean isSignBackSide() {
        return this.signBackSide;
    }

    @Override
    public void setSignBackSide(boolean signBackSide) {
        this.signBackSide = signBackSide;
    }

    @Override
    public boolean requiresTool() {
        return this.requiresTool;
    }

    @Override
    public void setRequiresTool(boolean requiresTool) {
        this.requiresTool = requiresTool;
    }

    @Override
    public boolean canSteal() {
        return this.canSteal;
    }

    @Override
    public void setCanSteal(boolean canSteal) {
        this.canSteal = canSteal;
    }

    @Override
    public void setCheckSight(boolean checkSight) {
        this.checkSight = checkSight;
    }

    @Override
    public boolean isCheckSight() {
        return this.checkSight;
    }

    @Override
    public boolean allowPickupOnStandby() {
        return this.allowStandbyPickup;
    }

    @Override
    public void setAllowStandbyPickup(boolean allowStandbyPickup) {
        this.allowStandbyPickup = allowStandbyPickup;
    }
}

