/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerAdapter;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import mekanism.api.heat.ISidedHeatHandler;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Mek2PNCHeatAdapter
extends IHeatExchangerAdapter.Simple<ISidedHeatHandler> {
    private final double thermalResistanceMult;

    public Mek2PNCHeatAdapter(Direction side, ISidedHeatHandler foreignHeatCap, double ambientTemperature, double thermalResistanceMult) {
        super(side, foreignHeatCap, ambientTemperature);
        this.thermalResistanceMult = thermalResistanceMult;
    }

    public static IHeatExchangerLogic maybe(BlockEntity blockEntity, Direction direction) {
        if (blockEntity instanceof ISidedHeatHandler) {
            ISidedHeatHandler handler = (ISidedHeatHandler)blockEntity;
            double ambient = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos());
            return new Mek2PNCHeatAdapter(direction, handler, ambient, Mek2PNCHeatAdapter.getResistanceMultiplier(blockEntity));
        }
        return null;
    }

    private static double getResistanceMultiplier(BlockEntity be) {
        return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.BLOCK_ENTITY_TYPE, be.getType()).map(name -> {
            if (name.getNamespace().equals("mekanism") && (name.getPath().equals("quantum_entangloporter") || name.getPath().endsWith("thermodynamic_conductor"))) {
                return 10000000;
            }
            return 1;
        }).orElse(1).intValue();
    }

    @Override
    public double getTemperature() {
        return ((ISidedHeatHandler)this.foreignHeatCap).getTemperature(0);
    }

    @Override
    public double getThermalResistance() {
        return ((ISidedHeatHandler)this.foreignHeatCap).getInverseConduction(0) * this.thermalResistanceMult;
    }

    @Override
    public double getThermalCapacity() {
        return ((ISidedHeatHandler)this.foreignHeatCap).getHeatCapacity(0);
    }

    @Override
    public void addHeat(double amount) {
        if (amount > 0.0) {
            ((ISidedHeatHandler)this.foreignHeatCap).handleHeat(amount / (Double)ConfigHelper.common().integration.mekThermalEfficiencyFactor.get());
        }
    }
}

