/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import vazkii.patchouli.api.IVariableSerializer;

public class FluidStackVariableSerializer
implements IVariableSerializer<FluidStack> {
    public FluidStack fromJson(JsonElement json, HolderLookup.Provider provider) {
        if (json.isJsonNull()) {
            return FluidStack.EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return FluidStackVariableSerializer.fluidStackFromString(json.getAsString());
        }
        if (json.isJsonObject()) {
            return FluidStackVariableSerializer.fluidStackFromJson((JsonElement)json.getAsJsonObject(), provider);
        }
        throw new IllegalArgumentException("Can't make an FluidStack from an array!");
    }

    public JsonElement toJson(FluidStack fluidStack, HolderLookup.Provider provider) {
        return FluidStackVariableSerializer.fluidStackToJson(fluidStack, provider);
    }

    private static FluidStack fluidStackFromString(String s) {
        ResourceLocation fluidId;
        String id = s;
        int count = 1000;
        String[] split = s.split("#");
        if (split.length > 1) {
            id = split[0];
            count = Integer.parseInt(split[1]);
        }
        if (!BuiltInRegistries.FLUID.containsKey(fluidId = ResourceLocation.parse((String)id))) {
            throw new RuntimeException("Unknown fluid: " + id);
        }
        Fluid f = (Fluid)BuiltInRegistries.FLUID.get(fluidId);
        return new FluidStack(f, count);
    }

    private static FluidStack fluidStackFromJson(JsonElement json, HolderLookup.Provider provider) {
        return FluidStack.OPTIONAL_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)json).result().orElse(FluidStack.EMPTY);
    }

    private static JsonElement fluidStackToJson(FluidStack f, HolderLookup.Provider provider) {
        return (JsonElement)FluidStack.OPTIONAL_CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)f).result().orElse(new JsonObject());
    }
}

