/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.heat.TemperatureListener;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncThermostatModuleToClient;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractNetworkedRedstoneModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ThermostatModule
extends AbstractNetworkedRedstoneModule
implements INetworkedModule,
TemperatureListener {
    public static final int MIN_VALUE = -273;
    public static final int MAX_VALUE = 2000;
    private int colorChannel;
    private int temperature = 0;
    private int threshold;
    private boolean update = true;

    public ThermostatModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
        this.lowerBound = -273.0f;
        this.higherBound = 2000.0f;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getTemperatureForLevel(int level) {
        float temperatureRange = this.higherBound - this.lowerBound;
        float levelNormalized = (float)level / 15.0f;
        float temperature = levelNormalized * temperatureRange + this.lowerBound;
        return (int)temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.THERMOSTAT_MODULE.get();
    }

    @Override
    public int getColorChannel() {
        return this.colorChannel;
    }

    @Override
    protected int getInputChannel() {
        return this.colorChannel;
    }

    @Override
    public void setColorChannel(int channel) {
        this.colorChannel = channel;
        this.setChanged();
    }

    @Override
    public double getWidth() {
        return 10.0;
    }

    @Override
    protected double getHeight() {
        return 5.0;
    }

    @Override
    public void addInfo(List<Component> curInfo) {
        super.addInfo(curInfo);
        if (this.advancedConfig) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.tubeModule.threshold_temp_bounds", PneumaticCraftUtils.roundNumberTo(this.lowerBound, 0), PneumaticCraftUtils.roundNumberTo(this.higherBound, 0)));
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.tubeModule.threshold_temp", PneumaticCraftUtils.roundNumberTo(this.getThreshold(), 1)));
        }
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.thermostatModule.temperature", this.temperature));
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.thermostatModule.level", this.getInputLevel()));
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)heldStack);
        if (dyeColor != null) {
            int colorId = dyeColor.getId();
            this.setColorChannel(colorId);
            if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue() && !player.isCreative()) {
                heldStack.shrink(1);
            }
            return true;
        }
        return super.onActivated(player, hand);
    }

    @NotNull
    private Optional<IHeatExchangerLogic> getHeatExchangerLogic() {
        return HeatExchangerManager.getInstance().getLogic(this.pressureTube.getLevel(), this.pressureTube.getBlockPos().relative(this.getDirection()), this.getDirection().getOpposite());
    }

    @Override
    public void onPlaced() {
        this.getHeatExchangerLogic().ifPresent(logic -> logic.addTemperatureListener(this));
    }

    @Override
    public void onRemoved() {
        this.getHeatExchangerLogic().ifPresent(logic -> logic.removeTemperatureListener(this));
    }

    @Override
    public void onNeighborBlockUpdate() {
        this.getHeatExchangerLogic().ifPresent(logic -> {
            logic.removeTemperatureListener(this);
            logic.addTemperatureListener(this);
        });
        this.updateInputLevel();
    }

    @Override
    public void onNeighborTileUpdate() {
        this.updateInputLevel();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.update) {
            this.update = false;
            this.updateInputLevel();
        }
    }

    @Override
    protected int calculateInputLevel() {
        this.getHeatExchangerLogic().ifPresent(logic -> this.setTemperature((int)logic.getTemperature() - 273));
        if (this.advancedConfig) {
            float temperatureRange = this.higherBound - this.lowerBound;
            float temperatureNormalized = ((float)this.temperature - this.lowerBound) / temperatureRange;
            int level = (int)(15.0f * temperatureNormalized);
            level = Math.max(0, Math.min(15, level));
            return level;
        }
        return this.temperature >= this.threshold ? 15 : 0;
    }

    @Override
    protected void onInputLevelChange(int level) {
        NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketSyncThermostatModuleToClient.forModule(this), this.getTube());
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putByte("channel", (byte)this.colorChannel);
        tag.putInt("temperature", this.temperature);
        tag.putInt("threshold", this.threshold);
        return tag;
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.colorChannel = tag.getByte("channel");
        this.temperature = tag.getInt("temperature");
        this.threshold = tag.getInt("threshold");
    }

    @Override
    public void onTemperatureChanged(double prevTemperature, double newTemperature) {
        this.setUpdate(true);
    }
}

