/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.ai;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class BeeAggressiveGoal
extends Goal {
    private final Bee bee;

    public BeeAggressiveGoal(Bee bee) {
        this.bee = bee;
    }

    public void tick() {
        List players = this.bee.level().getEntitiesOfClass(Player.class, new AABB(this.bee.blockPosition()).inflate(10.0, 5.0, 10.0));
        if (!players.isEmpty()) {
            this.bee.setTarget((LivingEntity)players.getFirst());
        }
    }

    public boolean canUse() {
        BeeAttributesHandler attributes = (BeeAttributesHandler)this.bee.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        return !this.bee.isAngry() && !this.bee.hasStung() && attributes.getAttributeValue(GeneAttribute.TEMPER).equals((Object)GeneValue.TEMPER_AGGRESSIVE);
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }
}

