/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BumbleBee;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BeeBodyLayer
extends RenderLayer<ProductiveBee, ProductiveBeeModel<ProductiveBee>> {
    private final String modelType;
    private final EntityModel<ProductiveBee> model;
    private final boolean isChristmas;
    public static Map<String, Map<String, ResourceLocation>> baseTextures = new HashMap<String, Map<String, ResourceLocation>>(){
        {
            this.put("default", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default/primary.png"));
                    this.put("abdomen", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default/abdomen.png"));
                    this.put("glowlayer", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default/primary.png"));
                    this.put("santahat", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default/santa_hat.png"));
                }
            });
            this.put("default_crystal", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_crystal/primary.png"));
                    this.put("abdomen", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_crystal/abdomen.png"));
                    this.put("glowlayer", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_crystal/crystals.png"));
                    this.put("crystals", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_crystal/crystals.png"));
                    this.put("crystals_clear", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_crystal/crystals_clear.png"));
                    this.put("santahat", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_crystal/santa_hat.png"));
                }
            });
            this.put("default_foliage", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_foliage/primary.png"));
                    this.put("abdomen", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_foliage/abdomen.png"));
                    this.put("glowlayer", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_foliage/crystals.png"));
                    this.put("crystals", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_foliage/crystals.png"));
                    this.put("santahat", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_foliage/santa_hat.png"));
                }
            });
            this.put("default_shell", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_shell/primary.png"));
                    this.put("abdomen", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_shell/abdomen.png"));
                    this.put("glowlayer", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_shell/crystals.png"));
                    this.put("crystals", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_shell/crystals.png"));
                    this.put("santahat", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/default_shell/santa_hat.png"));
                }
            });
            this.put("thicc", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/thicc/primary.png"));
                    this.put("abdomen", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/thicc/abdomen.png"));
                    this.put("santahat", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/thicc/santa_hat.png"));
                }
            });
            this.put("translucent_with_center", new HashMap<String, ResourceLocation>(){
                {
                    this.put("santahat", ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/entity/bee/base/translucent_with_center/santa_hat.png"));
                }
            });
        }
    };

    public BeeBodyLayer(RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>> rendererIn, ModelPart layer, String modelType, boolean isChristmas) {
        super(rendererIn);
        this.modelType = modelType;
        this.model = new ProductiveBeeModel(layer, modelType);
        this.isChristmas = isChristmas;
    }

    public void render(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.getRenderer().equals(this.modelType) && !entity.isInvisible()) {
            ((ProductiveBeeModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (entity instanceof ConfigurableBee && ((ConfigurableBee)entity).isTranslucent()) {
                VertexConsumer vertexBuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)entity)));
                this.model.renderToBuffer(matrixStackIn, vertexBuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), -1);
            } else {
                BeeBodyLayer.renderColoredCutoutModel(this.model, (ResourceLocation)this.getTextureLocation((Entity)entity), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (int)-1);
            }
            if (entity.isColored()) {
                this.renderColoredLayers(matrixStackIn, bufferIn, packedLightIn, entity, partialTicks);
            } else if (entity instanceof ConfigurableBee) {
                ConfigurableBee cBee = (ConfigurableBee)entity;
                if (this.modelType.equals("default_crystal") && cBee.useGlowLayer()) {
                    this.renderCrystalLayer(matrixStackIn, bufferIn, packedLightIn, entity, partialTicks);
                }
            }
            if (entity.hasNectar() && !entity.hasConverted()) {
                this.renderNectarLayer(matrixStackIn, bufferIn, packedLightIn, entity);
            }
            this.renderChristmasHat(matrixStackIn, bufferIn, packedLightIn, entity);
            this.renderSaddle(matrixStackIn, bufferIn, packedLightIn, entity);
        }
    }

    private void renderColoredLayers(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity, float partialTicks) {
        int primaryColor = entity.getColor(0, partialTicks);
        ResourceLocation location = baseTextures.get(this.modelType).get("primary");
        BeeBodyLayer.renderColoredCutoutModel(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (int)primaryColor);
        int secondaryColor = entity.getColor(1, partialTicks);
        ResourceLocation abdomenLocation = baseTextures.get(this.modelType).get("abdomen");
        BeeBodyLayer.renderColoredCutoutModel(this.model, (ResourceLocation)abdomenLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (int)secondaryColor);
        if (this.modelType.equals("default_crystal")) {
            this.renderCrystalLayer(matrixStackIn, bufferIn, packedLightIn, entity, partialTicks);
        } else if (this.modelType.equals("default_foliage") || this.modelType.equals("default_shell")) {
            int color = primaryColor;
            if (entity instanceof ConfigurableBee) {
                color = ((ConfigurableBee)entity).getTertiaryColor(partialTicks);
            }
            ResourceLocation foliageLocation = baseTextures.get(this.modelType).get("crystals");
            BeeBodyLayer.renderColoredCutoutModel(this.model, (ResourceLocation)foliageLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (int)color);
        }
    }

    private void renderCrystalLayer(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, ProductiveBee entity, float partialTicks) {
        boolean useGlowLayer;
        int color = entity.getColor(0, partialTicks);
        boolean bl = useGlowLayer = !entity.getRenderStatic();
        if (entity instanceof ConfigurableBee) {
            color = ((ConfigurableBee)entity).getTertiaryColor(partialTicks);
            useGlowLayer = useGlowLayer && ((ConfigurableBee)entity).useGlowLayer();
        }
        ResourceLocation crystalsLocation = baseTextures.get(this.modelType).get("crystals_clear");
        BeeBodyLayer.renderColoredCutoutModel(this.model, (ResourceLocation)crystalsLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (int)color);
        if (useGlowLayer) {
            ResourceLocation crystalsOverlayLocation = baseTextures.get(this.modelType).get("crystals");
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.eyes((ResourceLocation)crystalsOverlayLocation));
            this.model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, color);
        }
    }

    private void renderNectarLayer(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        if (entity.isColored()) {
            int colors = -1;
            if (entity instanceof ConfigurableBee) {
                if (((ConfigurableBee)entity).hasBeeTexture()) {
                    return;
                }
                if (((ConfigurableBee)entity).hasParticleColor()) {
                    colors = ((ConfigurableBee)entity).getParticleColor();
                }
            }
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/base/" + this.modelType + "/pollen.png");
            BeeBodyLayer.renderColoredCutoutModel(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (int)colors);
        }
    }

    private void renderChristmasHat(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        if (this.isChristmas && !entity.getRenderStatic() && this.modelType.contains("default")) {
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/base/" + this.modelType + "/santa_hat.png");
            BeeBodyLayer.renderColoredCutoutModel(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (int)-1);
        }
    }

    private void renderSaddle(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        BumbleBee bumbleBee;
        if (entity instanceof BumbleBee && (bumbleBee = (BumbleBee)entity).isSaddled()) {
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/bumble" + (bumbleBee.hasCustomName() && bumbleBee.getCustomName().getString().equals("Bleh") ? "_bleh" : "") + "/saddle.png");
            BeeBodyLayer.renderColoredCutoutModel(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (int)-1);
        }
    }
}

