/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.compat.harvest.HarvestCompatHandler;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class FarmerBee
extends ProductiveBee {
    public static final UUID FARMER_BEE_UUID = UUID.nameUUIDFromBytes("pb_farmer_bee".getBytes(StandardCharsets.UTF_8));
    private BlockPos targetHarvestPos = null;
    private LocateCropGoal locateCropGoal;

    public FarmerBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void registerGoals() {
        this.registerBaseGoals();
        this.goalSelector.addGoal(4, (Goal)new HarvestCropGoal());
        this.locateCropGoal = new LocateCropGoal();
        this.goalSelector.addGoal(6, (Goal)this.locateCropGoal);
    }

    @Override
    public boolean isInvulnerableTo(DamageSource source) {
        return source.equals(this.level().damageSources().cactus()) || super.isInvulnerableTo(source);
    }

    public List<BlockPos> findHarvestablesNearby(BlockPos pos, int distance) {
        return FarmerBee.findHarvestablesNearby(this.level(), pos, distance);
    }

    public static List<BlockPos> findHarvestablesNearby(Level level, BlockPos pos, int distance) {
        List<BlockPos> list = BlockPos.betweenClosedStream((BlockPos)pos.offset(-distance, -distance + 2, -distance), (BlockPos)pos.offset(distance, distance - 2, distance)).map(BlockPos::immutable).collect(Collectors.toList());
        list.removeIf(blockPos -> level.getBlockState(blockPos).isAir());
        list.removeIf(blockPos -> !FarmerBee.isCropValid(level, blockPos));
        return list;
    }

    public static boolean isCropValid(Level level, BlockPos blockPos) {
        return blockPos != null && HarvestCompatHandler.isCropValid(level, blockPos);
    }

    public void harvestBlock(BlockPos pos) {
        if (pos != null) {
            HarvestCompatHandler.harvestBlock(this.level(), pos);
        }
    }

    public class HarvestCropGoal
    extends Goal {
        private int ticks = 0;

        public boolean canUse() {
            if (FarmerBee.this.targetHarvestPos != null && !this.positionIsHarvestable(FarmerBee.this.targetHarvestPos)) {
                FarmerBee.this.targetHarvestPos = null;
            }
            return FarmerBee.this.targetHarvestPos != null && !FarmerBee.this.isAngry() && !FarmerBee.this.targetHarvestPos.closerToCenterThan((Position)FarmerBee.this.position(), 2.0);
        }

        public void start() {
            this.ticks = 0;
        }

        public void tick() {
            if (FarmerBee.this.targetHarvestPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    FarmerBee.this.locateCropGoal.cooldown = 120;
                    FarmerBee.this.targetHarvestPos = null;
                } else if (!FarmerBee.this.navigation.isDone()) {
                    BlockPos blockPos = FarmerBee.this.targetHarvestPos;
                    FarmerBee.this.navigation.moveTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 1.0);
                }
            }
        }

        private boolean positionIsHarvestable(BlockPos pos) {
            return !FarmerBee.this.findHarvestablesNearby(pos, 0).isEmpty();
        }
    }

    public class LocateCropGoal
    extends Goal {
        private int ticks = 0;
        private int cooldown = 0;

        public boolean canUse() {
            if (--this.cooldown <= 0 && !FarmerBee.this.isAngry()) {
                FarmerBee.this.targetHarvestPos = this.findNearestHarvestableTarget();
                if (FarmerBee.this.targetHarvestPos == null) {
                    this.cooldown = 70;
                }
            }
            return FarmerBee.this.targetHarvestPos != null;
        }

        public boolean canContinueToUse() {
            if (FarmerBee.this.tickCount % 20 == 0 && !FarmerBee.isCropValid(FarmerBee.this.level(), FarmerBee.this.targetHarvestPos)) {
                FarmerBee.this.targetHarvestPos = null;
            }
            return FarmerBee.this.targetHarvestPos != null && !FarmerBee.this.isAngry();
        }

        private BlockPos findNearestHarvestableTarget() {
            BlockEntity hive;
            if (FarmerBee.this.getHivePos() != null && (hive = FarmerBee.this.level().getBlockEntity(FarmerBee.this.getHivePos())) instanceof AdvancedBeehiveBlockEntity) {
                AdvancedBeehiveBlockEntity beehiveBlockEntity = (AdvancedBeehiveBlockEntity)hive;
                int radius = 5 + beehiveBlockEntity.getUpgradeCount((Item)LibItems.UPGRADE_RANGE.get());
                List<BlockPos> harvestablesNearby = FarmerBee.this.findHarvestablesNearby(FarmerBee.this.getHivePos(), radius);
                if (!harvestablesNearby.isEmpty()) {
                    BlockPos nearest = null;
                    double nearestDistance = 0.0;
                    for (BlockPos pos : harvestablesNearby) {
                        double distance = pos.distSqr((Vec3i)FarmerBee.this.blockPosition());
                        if (nearestDistance != 0.0 && !(distance <= nearestDistance)) continue;
                        nearestDistance = distance;
                        nearest = pos;
                    }
                    return nearest;
                }
            }
            return null;
        }

        public void start() {
            this.ticks = 0;
        }

        public void tick() {
            ++this.ticks;
            if (FarmerBee.this.targetHarvestPos != null) {
                if (this.ticks > 600) {
                    FarmerBee.this.targetHarvestPos = null;
                } else {
                    Vec3 vec3d = Vec3.atCenterOf((Vec3i)FarmerBee.this.targetHarvestPos).add(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.distanceTo(FarmerBee.this.position());
                    if (distanceToTarget > 1.5) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        FarmerBee.this.locateCropGoal.cooldown = 120;
                        FarmerBee.this.targetHarvestPos = null;
                    } else {
                        BlockPos pos = FarmerBee.this.targetHarvestPos;
                        if (FarmerBee.this.level().isLoaded(pos) && FarmerBee.isCropValid(FarmerBee.this.level(), pos)) {
                            FarmerBee.this.harvestBlock(pos);
                        }
                        FarmerBee.this.targetHarvestPos = null;
                        FarmerBee.this.playSound(SoundEvents.BEE_POLLINATE, 1.0f, 1.0f);
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3 nextTarget) {
            FarmerBee.this.getMoveControl().setWantedPosition(nextTarget.x, nextTarget.y, nextTarget.z, 1.0);
        }
    }
}

