/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class BottlerRecipe
implements Recipe<RecipeInput> {
    public final SizedFluidIngredient fluidInput;
    public final Ingredient itemInput;
    public final ItemStack result;

    public BottlerRecipe(SizedFluidIngredient fluidInput, Ingredient itemInput, ItemStack result) {
        this.fluidInput = fluidInput;
        this.itemInput = itemInput;
        this.result = result;
    }

    public boolean matches(FluidStack fluid, ItemStack inputStack) {
        if (!this.itemInput.test(inputStack)) {
            return false;
        }
        return this.fluidInput.test(fluid);
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BOTTLER.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.BOTTLER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BottlerRecipe> {
        private static final MapCodec<BottlerRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(recipe -> recipe.fluidInput), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.itemInput), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, BottlerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BottlerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BottlerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BottlerRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BottlerRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new BottlerRecipe((SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)buffer), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bottler recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BottlerRecipe recipe) {
            try {
                SizedFluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidInput);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.itemInput);
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bottler recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

