/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.emi;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.client.render.ingredient.BeeRenderer;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class BeeEmiStack
extends EmiStack {
    private final BeeIngredient beeIngredient;

    private BeeEmiStack(BeeIngredient beeIngredient) {
        this.beeIngredient = beeIngredient == null ? BeeIngredientFactory.getIngredient("minecraft:bee").get() : beeIngredient;
    }

    public static BeeEmiStack of(BeeIngredient beeIngredient) {
        return new BeeEmiStack(beeIngredient);
    }

    public EmiStack copy() {
        return new BeeEmiStack(this.beeIngredient);
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null) {
            BeeRenderer.render(draw, x, y, this.beeIngredient, Minecraft.getInstance());
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return this.beeIngredient.getBeeType();
    }

    public ResourceLocation getId() {
        return this.beeIngredient.getBeeType().withPath(p -> "/" + p);
    }

    public boolean isEqual(EmiStack stack) {
        if (stack instanceof BeeEmiStack) {
            BeeEmiStack beeEmiStack = (BeeEmiStack)stack;
            return beeEmiStack.beeIngredient.getBeeType().equals((Object)this.beeIngredient.getBeeType());
        }
        return super.isEqual(stack);
    }

    public List<Component> getTooltipText() {
        ArrayList<Component> list = new ArrayList<Component>();
        CompoundTag data = BeeReloadListener.INSTANCE.getData(this.beeIngredient.getBeeType());
        if (data != null) {
            list.add((Component)Component.translatable((String)("entity.productivebees." + ProductiveBee.getBeeName(this.beeIngredient.getBeeType()) + "_bee")));
            if (!data.getString("group").isEmpty()) {
                list.add((Component)Component.literal((String)data.getString("group")));
            }
        }
        list.add((Component)Component.literal((String)this.beeIngredient.getBeeType().toString()).withStyle(ChatFormatting.DARK_GRAY));
        list.add((Component)Component.translatable((String)"itemGroup.productivebees").withStyle(ChatFormatting.DARK_BLUE));
        return list;
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        if (!this.isEmpty()) {
            list.add(ClientTooltipComponent.create((FormattedCharSequence)this.getName().getVisualOrderText()));
            list.add(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)this.beeIngredient.getBeeType().toString()).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText()));
            list.add(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"itemGroup.productivebees").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC).getVisualOrderText()));
            list.addAll(super.getTooltip());
        }
        return list;
    }

    public Component getName() {
        return Component.translatable((String)("entity.productivebees." + ProductiveBee.getBeeName(this.beeIngredient.getBeeType()) + "_bee"));
    }
}

