/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.CatcherBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class CatcherContainer
extends AbstractContainer<CatcherBlockEntity> {
    public CatcherContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CatcherContainer.getTileEntity(playerInventory, data));
    }

    public CatcherContainer(int windowId, Inventory playerInventory, CatcherBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.CATCHER.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((CatcherBlockEntity)this.getBlockEntity()).getItemHandler(), 0, 26, 35));
        this.addSlotBox(((CatcherBlockEntity)this.getBlockEntity()).getItemHandler(), InventoryHandlerHelper.OUTPUT_SLOTS[0], 80, 17, 3, 18, 3, 18);
        this.addSlotBox((IItemHandler)((CatcherBlockEntity)this.getBlockEntity()).getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static CatcherBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof CatcherBlockEntity) {
            return (CatcherBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

