/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.GeneIndexerBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GeneIndexerContainer
extends AbstractContainer<GeneIndexerBlockEntity> {
    public GeneIndexerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, GeneIndexerContainer.getBlockEntity(playerInventory, data));
    }

    public GeneIndexerContainer(int windowId, Inventory playerInventory, GeneIndexerBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.GENE_INDEXER.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addSlotBox(((GeneIndexerBlockEntity)this.getBlockEntity()).getItemHandler(), 0, 12, 16, 13, 18, 8, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 48, 174);
    }

    private static GeneIndexerBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof GeneIndexerBlockEntity) {
            return (GeneIndexerBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

