/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.HeatedCentrifugeBlockEntity;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HeatedCentrifugeContainer<T extends CentrifugeBlockEntity>
extends CentrifugeContainer<T> {
    public HeatedCentrifugeContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, HeatedCentrifugeContainer.getTileEntity(playerInventory, data));
    }

    public HeatedCentrifugeContainer(int windowId, Inventory playerInventory, T blockEntity) {
        super((MenuType)ModContainerTypes.HEATED_CENTRIFUGE.get(), windowId, playerInventory, blockEntity);
        this.addDataSlot(new DataSlot(this, (CentrifugeBlockEntity)blockEntity){
            final /* synthetic */ CentrifugeBlockEntity val$blockEntity;
            {
                this.val$blockEntity = centrifugeBlockEntity;
            }

            public int get() {
                return this.val$blockEntity.getEnergyHandler().getEnergyStored();
            }

            public void set(int value) {
                if (this.val$blockEntity.getEnergyHandler().getEnergyStored() > 0) {
                    this.val$blockEntity.getEnergyHandler().extractEnergy(this.val$blockEntity.getEnergyHandler().getEnergyStored(), false);
                }
                if (value > 0) {
                    this.val$blockEntity.getEnergyHandler().receiveEnergy(value, false);
                }
            }
        });
    }

    private static HeatedCentrifugeBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof HeatedCentrifugeBlockEntity) {
            HeatedCentrifugeBlockEntity tile = (HeatedCentrifugeBlockEntity)tileAtPos;
            return tile;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

