/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BlueBandedBee;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.dispenser.CageDispenseBehavior;
import cy.jdkdigital.productivebees.dispenser.ShearsDispenseItemBehavior;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.network.packets.BeeDataMessage;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.ProductiveLib;
import cy.jdkdigital.productivelib.common.item.AbstractUpgradeItem;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="productivebees")
public class ModEventHandler {
    @SubscribeEvent
    public static void tabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceLocation beeType;
        if (event.getTabKey().equals(ProductiveBees.TAB_KEY)) {
            for (DeferredHolder deferredHolder : ProductiveBees.ITEMS.getEntries()) {
                if (deferredHolder.equals(ModItems.CONFIGURABLE_HONEYCOMB) || deferredHolder.equals(ModItems.CONFIGURABLE_COMB_BLOCK) || deferredHolder.equals(ModItems.CONFIGURABLE_SPAWN_EGG) || deferredHolder.equals(ModItems.GENE) || deferredHolder.equals(ModItems.GENE_BOTTLE) || deferredHolder.equals(ModItems.ADV_BREED_ALL_BEES) || deferredHolder.equals(ModItems.ADV_BREED_BEE) || deferredHolder.get() instanceof SpawnEggItem || deferredHolder.get() instanceof AbstractUpgradeItem) continue;
                event.accept(new ItemStack((ItemLike)deferredHolder.get(), 1));
            }
            for (DeferredHolder deferredHolder : ProductiveLib.ITEMS.getEntries()) {
                if (deferredHolder.is((Holder)LibItems.UPGRADE_POLLEN_SIEVE)) continue;
                event.accept(((Item)deferredHolder.get()).getDefaultInstance());
            }
            for (Map.Entry entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
                beeType = (ResourceLocation)entry.getKey();
                if (!((CompoundTag)entry.getValue()).getBoolean("createComb")) continue;
                ItemStack comb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                BeeCreator.setType(beeType, comb);
                event.accept(comb);
                ItemStack combBlock = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
                BeeCreator.setType(beeType, combBlock);
                event.accept(combBlock);
            }
            event.accept(Gene.getStack(GeneAttribute.PRODUCTIVITY, GeneValue.PRODUCTIVITY_NORMAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.PRODUCTIVITY, GeneValue.PRODUCTIVITY_MEDIUM, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.PRODUCTIVITY, GeneValue.PRODUCTIVITY_HIGH, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.PRODUCTIVITY, GeneValue.PRODUCTIVITY_VERY_HIGH, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_NONE, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_RAIN, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_ANY, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.BEHAVIOR, GeneValue.BEHAVIOR_DIURNAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.BEHAVIOR, GeneValue.BEHAVIOR_NOCTURNAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.BEHAVIOR, GeneValue.BEHAVIOR_METATURNAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.TEMPER, GeneValue.TEMPER_PASSIVE, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.TEMPER, GeneValue.TEMPER_NORMAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.TEMPER, GeneValue.TEMPER_HOSTILE, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.TEMPER, GeneValue.TEMPER_AGGRESSIVE, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.ENDURANCE, GeneValue.ENDURANCE_WEAK, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.ENDURANCE, GeneValue.ENDURANCE_NORMAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.ENDURANCE, GeneValue.ENDURANCE_MEDIUM, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.ENDURANCE, GeneValue.ENDURANCE_STRONG, 1, 100));
            BeeReloadListener.INSTANCE.getData().forEach((location, compoundTag) -> event.accept(Gene.getStack(GeneAttribute.TYPE, location.toString(), 1, 100)));
            for (ResourceLocation resourceLocation : BuiltInRegistries.ENTITY_TYPE.keySet()) {
                if (!resourceLocation.getNamespace().equals("productivebees") || !resourceLocation.getPath().contains("bee") || resourceLocation.toString().equals("productivebees:configurable_bee")) continue;
                event.accept(Gene.getStack(GeneAttribute.TYPE, resourceLocation.toString(), 1, 100));
            }
        }
        if (event.getTabKey().equals(ProductiveBees.TAB_KEY) || event.getTabKey().equals(CreativeModeTabs.SPAWN_EGGS)) {
            for (DeferredHolder deferredHolder : ModItems.SPAWN_EGGS) {
                if (deferredHolder.equals(ModItems.CONFIGURABLE_SPAWN_EGG)) continue;
                event.accept(new ItemStack((Holder)deferredHolder));
            }
            for (Map.Entry entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
                beeType = (ResourceLocation)entry.getKey();
                event.accept(BeeCreator.getSpawnEgg(beeType));
            }
        }
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.BEE_CAGE.get()), (DispenseItemBehavior)new CageDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.STURDY_BEE_CAGE.get()), (DispenseItemBehavior)new CageDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)Items.SHEARS.asItem(), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
        });
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ModEntities.CONFIGURABLE_BEE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, serverLevel, spawnType, pos, random) -> random.nextBoolean() && spawnType.equals((Object)MobSpawnType.NATURAL) && serverLevel.getBlockState(pos).canBeReplaced(), RegisterSpawnPlacementsEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        EntityType bee;
        for (DeferredHolder registryObject : ModEntities.HIVE_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            event.put(bee, Bee.createAttributes().build());
        }
        for (DeferredHolder registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            if (bee.getDescriptionId().contains("blue_banded_bee")) continue;
            event.put(bee, Bee.createAttributes().build());
        }
        event.put((EntityType)ModEntities.BLUE_BANDED_BEE.get(), BlueBandedBee.getDefaultAttributes().build());
    }

    @SubscribeEvent
    public static void payloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("productivebees").versioned("1").optional();
        registrar.playToClient(BeeDataMessage.TYPE, BeeDataMessage.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(BeeDataMessage::clientHandle, BeeDataMessage::serverHandle));
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
    }

    @SubscribeEvent
    public static void registerBlockEntityCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.ADVANCED_HIVE.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.CANVAS_ADVANCED_HIVE.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.EXPANSION_BOX.get(), (myBlockEntity, side) -> {
            if (side != null && (side.equals((Object)Direction.DOWN) || side.equals((Object)Direction.UP))) {
                return myBlockEntity.getHiveUpgradeHandler();
            }
            return myBlockEntity.getHiveInventoryHandler();
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.CANVAS_EXPANSION_BOX.get(), (myBlockEntity, side) -> {
            if (side != null && (side.equals((Object)Direction.DOWN) || side.equals((Object)Direction.UP))) {
                return myBlockEntity.getHiveUpgradeHandler();
            }
            return myBlockEntity.getHiveInventoryHandler();
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.DRACONIC_BEEHIVE.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.POWERED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.POWERED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.POWERED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.HEATED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.HEATED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.HEATED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BOTTLER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BOTTLER.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.FEEDER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.JAR.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.HONEY_GENERATOR.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.HONEY_GENERATOR.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.HONEY_GENERATOR.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.CATCHER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.INCUBATOR.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.INCUBATOR.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.GENE_INDEXER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BREEDING_CHAMBER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.BREEDING_CHAMBER.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
    }
}

