/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;

public class BeeCreator {
    public static CompoundTag create(ResourceLocation id, JsonObject json) {
        CompoundTag data = new CompoundTag();
        data.putString("id", id.toString());
        data.putInt("primaryColor", BeeCreator.getColor(json, "primaryColor").intValue());
        data.putInt("secondaryColor", json.has("secondaryColor") ? BeeCreator.getColor(json, "secondaryColor").intValue() : data.getInt("primaryColor"));
        if (json.has("description")) {
            data.putString("description", json.get("description").getAsString());
        }
        data.putBoolean("inverseFlower", false);
        if (json.has("flowerTag") && !json.get("flowerTag").getAsString().isEmpty()) {
            String tagName = json.get("flowerTag").getAsString();
            if (tagName.startsWith("!")) {
                tagName = tagName.substring(1);
                data.putBoolean("inverseFlower", true);
            }
            data.putString("flowerTag", tagName);
        } else if (json.has("flowerBlock") && !json.get("flowerBlock").getAsString().isEmpty()) {
            data.putString("flowerBlock", json.get("flowerBlock").getAsString());
        } else if (json.has("flowerFluid") && !json.get("flowerFluid").getAsString().isEmpty()) {
            data.putString("flowerFluid", json.get("flowerFluid").getAsString());
        } else if (json.has("flowerItem") && !json.get("flowerItem").getAsString().isEmpty()) {
            data.putString("flowerItem", json.get("flowerItem").getAsString());
        } else {
            data.putString("flowerTag", "minecraft:flowers");
        }
        if (json.has("nestingPreference")) {
            data.putString("nestingPreference", json.get("nestingPreference").getAsString());
        }
        if (json.has("beeTexture")) {
            data.putString("beeTexture", json.get("beeTexture").getAsString());
        }
        if (json.has("particleColor")) {
            data.putInt("particleColor", BeeCreator.getColor(json, "particleColor").intValue());
        }
        data.putInt("tertiaryColor", json.has("tertiaryColor") ? BeeCreator.getColor(json, "tertiaryColor").intValue() : data.getInt("primaryColor"));
        if (json.has("attackResponse")) {
            data.putString("attackResponse", json.get("attackResponse").getAsString());
        }
        if (json.has("postPollination")) {
            data.putString("postPollination", json.get("postPollination").getAsString());
        }
        data.putBoolean("colorCycle", json.has("colorCycle") && json.get("colorCycle").getAsBoolean());
        if (json.has("model")) {
            data.putString("model", json.get("model").getAsString());
        }
        if (json.has("animation")) {
            data.putString("animation", json.get("animation").getAsString());
        }
        data.putString("breedingItem", json.has("breedingItem") ? json.get("breedingItem").getAsString() : "");
        data.putInt("breedingItemCount", json.has("breedingItemCount") ? json.get("breedingItemCount").getAsInt() : 1);
        data.putString("flowerType", json.has("flowerType") ? json.get("flowerType").getAsString() : "blocks");
        data.putString("renderer", json.has("renderer") ? json.get("renderer").getAsString() : "default");
        data.putString("renderTransform", json.has("renderTransform") ? json.get("renderTransform").getAsString() : "none");
        data.putString("particleType", json.has("particleType") ? json.get("particleType").getAsString() : "drip");
        data.putFloat("size", json.has("size") ? json.get("size").getAsFloat() : 1.0f);
        data.putFloat("pollinatedSize", json.has("pollinatedSize") ? json.get("pollinatedSize").getAsFloat() : data.getFloat("size"));
        data.putFloat("speed", json.has("speed") ? json.get("speed").getAsFloat() : 1.0f);
        data.putDouble("attack", json.has("attack") ? (double)json.get("attack").getAsFloat() : 2.0);
        data.putBoolean("translucent", json.has("translucent") && json.get("translucent").getAsBoolean() || data.getString("renderer").equals("translucent_with_center"));
        data.putBoolean("useGlowLayer", json.has("useGlowLayer") ? json.get("useGlowLayer").getAsBoolean() : data.getString("renderer").equals("default_crystal"));
        data.putBoolean("fireproof", json.has("fireproof") && json.get("fireproof").getAsBoolean());
        data.putBoolean("withered", json.has("withered") && json.get("withered").getAsBoolean());
        data.putBoolean("blinding", json.has("blinding") && json.get("blinding").getAsBoolean());
        data.putBoolean("draconic", json.has("draconic") && json.get("draconic").getAsBoolean());
        data.putBoolean("slimy", json.has("slimy") && json.get("slimy").getAsBoolean());
        data.putBoolean("teleporting", json.has("teleporting") && json.get("teleporting").getAsBoolean());
        data.putBoolean("munchies", json.has("munchies") && json.get("munchies").getAsBoolean());
        data.putBoolean("redstoned", json.has("redstoned") && json.get("redstoned").getAsBoolean());
        data.putBoolean("stringy", json.has("stringy") && json.get("stringy").getAsBoolean());
        data.putBoolean("stingless", json.has("stingless") && json.get("stingless").getAsBoolean());
        data.putBoolean("waterproof", json.has("waterproof") && json.get("waterproof").getAsBoolean());
        data.putBoolean("coldResistant", json.has("coldResistant") && json.get("coldResistant").getAsBoolean());
        data.putBoolean("selfbreed", !json.has("selfbreed") || json.get("selfbreed").getAsBoolean());
        data.putBoolean("selfheal", json.has("selfheal") && json.get("selfheal").getAsBoolean());
        data.putBoolean("irradiated", json.has("irradiated") && json.get("irradiated").getAsBoolean());
        ListTag invulnerability = new ListTag();
        if (json.has("invulnerability")) {
            for (JsonElement damageSource : json.get("invulnerability").getAsJsonArray()) {
                invulnerability.add((Object)StringTag.valueOf((String)damageSource.getAsString()));
            }
        }
        data.put("invulnerability", (Tag)invulnerability);
        if (json.has("attributes")) {
            for (Map.Entry entry : json.get("attributes").getAsJsonObject().entrySet()) {
                switch ((String)entry.getKey()) {
                    case "productivity": 
                    case "endurance": 
                    case "temper": 
                    case "behavior": 
                    case "weather_tolerance": {
                        data.putString((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                }
            }
        }
        if (json.has("passiveEffects")) {
            // empty if block
        }
        data.putBoolean("createComb", !json.has("createComb") || json.get("createComb").getAsBoolean());
        return data;
    }

    public static void setType(ResourceLocation type, ItemStack stack) {
        stack.set(ModDataComponents.BEE_TYPE, (Object)type);
    }

    public static ItemStack getSpawnEgg(ResourceLocation beeType) {
        return BeeCreator.getSpawnEgg(beeType, false);
    }

    public static ItemStack getSpawnEgg(ResourceLocation beeType, boolean forceConfigurable) {
        ItemStack egg;
        if (BeeReloadListener.INSTANCE.getData(beeType) != null || forceConfigurable) {
            egg = new ItemStack((ItemLike)ModItems.CONFIGURABLE_SPAWN_EGG.get());
            CompoundTag tag = new CompoundTag();
            tag.putString("type", beeType.toString());
            tag.putString("id", ModEntities.CONFIGURABLE_BEE.getId().toString());
            egg.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
        } else {
            egg = beeType.getNamespace().equals("productivebees") ? new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)beeType.getNamespace(), (String)("spawn_egg_" + beeType.getPath())))) : new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)beeType.getNamespace(), (String)(beeType.getPath() + "_spawn_egg"))));
        }
        return egg;
    }

    private static Integer getColor(JsonObject json, String el) {
        String[] c = json.get(el).getAsString().replace("#", "").split("(?<=\\G.{2})");
        return FastColor.ARGB32.color((int)Integer.parseInt(c[0], 16), (int)Integer.parseInt(c[1], 16), (int)Integer.parseInt(c[2], 16));
    }
}

