/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block;

import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;

public class ProductiveSaplingBlock
extends SaplingBlock {
    private final TreeObject treeObject;

    public ProductiveSaplingBlock(TreeGrower grower, BlockBehaviour.Properties properties, TreeObject treeObject) {
        super(grower, properties);
        this.treeObject = treeObject;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(this.treeObject.getSoil());
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return this.treeObject.canForceGrowth();
    }

    public TreeObject getTree() {
        return this.treeObject;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        BlockItem blockItem;
        Item item = pStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof ProductiveSaplingBlock) {
            ProductiveSaplingBlock saplingBlock = (ProductiveSaplingBlock)item;
            pTootipComponents.add((Component)Component.translatable((String)("block.productivetrees." + saplingBlock.treeObject.getId().getPath() + ".latin")).withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.ITALIC));
            super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
            Object configurations = "";
            if (!saplingBlock.treeObject.getFeature().equals(TreeRegistrator.NULL_FEATURE)) {
                configurations = (String)configurations + "1x1 ";
            }
            if (!saplingBlock.treeObject.getMegaFeature().equals(TreeRegistrator.NULL_FEATURE)) {
                configurations = (String)configurations + "2x2 ";
            }
            if (!((String)configurations).isEmpty()) {
                pTootipComponents.add((Component)Component.translatable((String)"productivetrees.sapling.configurations", (Object[])new Object[]{configurations}).withStyle(ChatFormatting.GOLD));
            }
        } else {
            super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (random.nextInt(7) == 0 && this.canGrowAtPos(level, pos)) {
            this.advanceTree(level, pos, state, random);
        }
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        ServerLevel serverLevel;
        return super.isBonemealSuccess(level, random, pos, state) && level instanceof ServerLevel && this.canGrowAtPos(serverLevel = (ServerLevel)level, pos);
    }

    private boolean canGrowAtPos(ServerLevel level, BlockPos pos) {
        int lightLevel = level.getMaxLocalRawBrightness(pos.above());
        if (lightLevel >= this.treeObject.getGrowthConditions().minLight() && lightLevel <= this.treeObject.getGrowthConditions().maxLight()) {
            if (!this.treeObject.getGrowthConditions().fluid().equals(Fluids.EMPTY) && !level.getFluidState(pos).is(this.treeObject.getGrowthConditions().fluid().getFluid())) {
                return false;
            }
            Holder biome = level.getBiome(pos);
            return this.treeObject.getGrowthConditions().biome() == null || this.treeObject.getGrowthConditions().biome().isEmpty() || this.treeObject.getGrowthConditions().biome().get().contains(biome);
        }
        return true;
    }
}

