/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import cy.jdkdigital.productivelib.util.LangUtil;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.HashMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class LanguageProvider
extends net.neoforged.neoforge.common.data.LanguageProvider {
    public LanguageProvider(PackOutput output) {
        super(output, "productivetrees", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.productivetrees", "Productive Trees");
        this.add("block.productivetrees.maple_sap", "Maple Sap");
        this.add("jei.productivetrees.tree_pollination", "Tree Pollination");
        this.add("jei.productivetrees.tree_fruiting", "Tree Fruiting");
        this.add("jei.productivetrees.log_stripping", "Log Stripping");
        this.add("jei.productivetrees.sawmill", "Sawmill");
        this.add("emi.category.productivetrees.pollination", "Tree Pollination");
        this.add("emi.category.productivetrees.fruiting", "Tree Fruiting");
        this.add("emi.category.productivetrees.stripping", "Log Stripping");
        this.add("emi.category.productivetrees.sawmill", "Sawmill");
        this.add("productivetrees.pollen.name", "%s");
        this.add("productivetrees.screen.progress", "Progress: %s");
        this.add("productivetrees.devices.advanced_beehive", "Advanced Beehive");
        this.add("productivetrees.information.upgrade.upgrade_pollen_sieve.advanced_hive", "With this upgrade installed in the hive some pollen collected by bees will be sifted and deposited in the hive.");
        this.add("productivetrees.information.upgrade.upgrade_time.stripper", "Each upgrade increases the number of items processed per operation by 4.\n   Multiple upgrades can be installed for a greater time decrease.");
        this.add("productivetrees.information.upgrade.upgrade_time.sawmill", "Can be installed in machines for faster processing.\n   Multiple upgrades can be installed for a greater time decrease.");
        this.add("productivetrees.information.upgrade.upgrade_time.pollen_sifter", "Can be installed in machines for faster processing.\n   Multiple upgrades can be installed for a greater time decrease.");
        this.add("productivetrees.information.upgrade.upgrade_time_2.stripper", "It's twice as good as the other one.");
        this.add("productivetrees.information.upgrade.upgrade_time_2.sawmill", "It's twice as good as the other one.");
        this.add("productivetrees.information.upgrade.upgrade_time_2.pollen_sifter", "It's twice as good as the other one.");
        this.add("productivetrees.information.pollen", "Use on a leaf to manually pollinate it.");
        this.add("productivetrees.sapling.configurations", "Configurations: %s");
        this.add("item.productivetrees.roasted_coffee_bean", "Roasted Coffee Beans");
        this.add("productivetrees.sapling_description.black_ember", "Black Ember saplings can be found hidden away in bastion treasure chests in the Nether guarded by wild and hangry brutes.");
        this.add("productivetrees.sapling_description.blue_yonder", "Blue Yonder saplings loved to travel and see the world. They were transported by ship because of their delicate roots and can still be found in the treasure chests of sunken galleons.");
        this.add("productivetrees.sapling_description.firecracker", "These explosive trees were banned from parties eons ago but can still be found in ancient cities deep underground.");
        this.add("productivetrees.sapling_description.flickering_sun", "In the treasure rooms of desert temples among the rotten flesh, bones and spider eyes you'll sometimes find this rare sapling.");
        this.add("productivetrees.sapling_description.soul_tree", "Can be found where saplings go to die, in the far reached on the end in cities long forgotten.");
        this.add("productivetrees.sapling_description.brown_amber", "Tucked beneath the crushing weight of the cold ocean water, this sapling is waiting to be unearthed.");
        this.add("entity.productivebees.allergy_bee", "Allergy Bee");
        this.add("productivebees.ingredient.description.allergy_bee", "Puts in an extra effort to collect pollen so your allergies don't act up while working with trees.");
        this.add("productivetrees.devices.stripper", "Stripper");
        this.add("productivetrees.devices.sawmill", "Sawmill");
        this.add("productivetrees.devices.pollen_sifter", "Pollen Sifter");
        this.add("productivebees.devices.advanced_beehive", "Advanced Beehive");
        this.add((Block)TreeRegistrator.POLLINATED_LEAVES.get(), "Pollinated Leaves");
        this.add((Block)TreeRegistrator.STRIPPER.get(), "Stripper");
        this.add((Block)TreeRegistrator.SAWMILL.get(), "Sawmill");
        this.add((Block)TreeRegistrator.WOOD_WORKER.get(), "Carpentry Bench");
        this.add((Block)TreeRegistrator.POLLEN_SIFTER.get(), "Pollen Sifter");
        this.add((Block)TreeRegistrator.TIME_TRAVELLER_DISPLAY.get(), "Time Traveller Display");
        this.add((Block)TreeRegistrator.COCONUT_SPROUT.get(), "Coconut Sprout");
        this.add((Item)TreeRegistrator.POLLEN.get(), "Pollen");
        this.add((Item)TreeRegistrator.SAWDUST.get(), "Sawdust");
        this.add((Item)TreeRegistrator.ALLSPICE.get(), "Allspice");
        this.add((Item)TreeRegistrator.CAROB.get(), "Carob");
        this.add((Item)TreeRegistrator.COFFEE_BEAN.get(), "Coffee Beans");
        this.add((Item)TreeRegistrator.CLOVE.get(), "Clove");
        this.add((Item)TreeRegistrator.CINNAMON.get(), "Cinnamon");
        this.add((Item)TreeRegistrator.NUTMEG.get(), "Nutmeg");
        this.add((Item)TreeRegistrator.STAR_ANISE.get(), "Star Anise");
        this.add((Item)TreeRegistrator.CORK.get(), "Cork");
        this.add((Item)TreeRegistrator.FUSTIC.get(), "Fustic");
        this.add((Item)TreeRegistrator.HAEMATOXYLIN.get(), "Haematoxylin");
        this.add((Item)TreeRegistrator.DRACAENA_SAP.get(), "Dracaena Sap");
        this.add((Item)TreeRegistrator.MAPLE_SAP_BUCKET.get(), "Maple Sap");
        this.add((Item)TreeRegistrator.RUBBER.get(), "Rubber");
        this.add((Item)TreeRegistrator.CURED_RUBBER.get(), "Cured Rubber");
        this.add((Item)TreeRegistrator.SANDALWOOD_OIL.get(), "Sandalwood Oil");
        ProductiveTrees.ITEMS.getEntries().forEach(itemDeferredHolder -> {
            ItemStack stack = new ItemStack((ItemLike)itemDeferredHolder.get());
            if (stack.has(DataComponents.FOOD)) {
                this.add((Item)itemDeferredHolder.get(), LangUtil.capName((String)BuiltInRegistries.ITEM.getKey((Object)((Item)itemDeferredHolder.get())).getPath()));
            }
        });
        TreeRegistrator.CRATED_CROPS.forEach(crate -> this.add((Block)BuiltInRegistries.BLOCK.get(crate), "Crate of " + LangUtil.pluralCapName((String)crate.getPath().replace("_crate", ""))));
        TreeFinder.trees.forEach((id, treeObject) -> {
            String name = id.getPath();
            this.add(TreeUtil.getBlock(id, "_leaves"), LangUtil.capName((String)name) + " Leaves");
            this.add(TreeUtil.getBlock(id, "_sapling"), LangUtil.capName((String)name) + " Sapling");
            this.add(TreeUtil.getBlock(id, "_potted_sapling"), LangUtil.capName((String)name) + " Potted Sapling");
            if (treeObject.hasFruit()) {
                this.add(TreeUtil.getBlock(id, "_fruit"), LangUtil.capName((String)name) + " Fruiting Leaves");
                if (!treeObject.getId().getPath().contains("copper_beech") && !treeObject.getId().getPath().contains("purple_blackthorn")) {
                    this.add("tag.item.c.storage_blocks." + treeObject.getFruit().fruitItem().getPath(), LangUtil.pluralCapName((String)treeObject.getFruit().fruitItem().getPath()));
                }
            }
            this.addWoodStuff((WoodObject)treeObject, name);
            this.add("block.productivetrees." + name + ".latin", LanguageProvider.getLatinName(name));
            this.add("tag.item.productivetrees." + name + "_logs", LangUtil.capName((String)name) + " Logs");
        });
    }

    private void addWoodStuff(WoodObject woodObject, String name) {
        this.add(TreeUtil.getBlock(woodObject.getId(), "_log"), LangUtil.capName((String)name) + " Log");
        this.add(TreeUtil.getBlock(woodObject.getId(), "_wood"), LangUtil.capName((String)name) + " Wood");
        this.add(TreeUtil.getBlock(woodObject.getId(), "_stripped_log"), LangUtil.capName((String)name) + " Stripped Log");
        this.add(TreeUtil.getBlock(woodObject.getId(), "_stripped_wood"), LangUtil.capName((String)name) + " Stripped Wood");
        this.add(TreeUtil.getBlock(woodObject.getId(), "_planks"), LangUtil.capName((String)name) + " Planks");
        if (!ProductiveTrees.isMinimal) {
            this.add(TreeUtil.getBlock(woodObject.getId(), "_stairs"), LangUtil.capName((String)name) + " Stairs");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_slab"), LangUtil.capName((String)name) + " Slab");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_fence"), LangUtil.capName((String)name) + " Fence");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_fence_gate"), LangUtil.capName((String)name) + " Fence Gate");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_button"), LangUtil.capName((String)name) + " Button");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_pressure_plate"), LangUtil.capName((String)name) + " Pressure Plate");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_door"), LangUtil.capName((String)name) + " Door");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_trapdoor"), LangUtil.capName((String)name) + " Trapdoor");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_bookshelf"), LangUtil.capName((String)name) + " Bookshelf");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_sign"), LangUtil.capName((String)name) + " Sign");
            this.add(TreeUtil.getBlock(woodObject.getId(), "_hanging_sign"), LangUtil.capName((String)name) + " Hanging Sign");
        }
        if (woodObject.getStyle().hiveStyle() != null) {
            this.add("block.productivetrees." + woodObject.getId().withPath(p -> "advanced_" + p + "_beehive").getPath(), "Advanced " + LangUtil.capName((String)name) + " Beehive");
            this.add("block.productivetrees." + woodObject.getId().withPath(p -> "expansion_box_" + p).getPath(), LangUtil.capName((String)name) + " Expansion Box");
        }
    }

    public String getName() {
        return "Productive Trees translation provider";
    }

    private static String getLatinName(String name) {
        HashMap<String, String> names = new HashMap<String, String>(){
            {
                this.put("alder", "Alnus glutinosa");
                this.put("allspice", "Pimenta dioica");
                this.put("almond", "Prunus amygdalus");
                this.put("apricot", "Prunus Armeniaca");
                this.put("aquilaria", "Aquilaria malaccensis");
                this.put("asai_palm", "Euterpe oleracea");
                this.put("ash", "Fraxinus excelsior");
                this.put("aspen", "Populus tremula");
                this.put("avocado", "Persea americana");
                this.put("balsa", "Ochroma pyramidale");
                this.put("balsam_fir", "Abies balsamea");
                this.put("banana", "Musa acuminata");
                this.put("beech", "Fagus sylvatica");
                this.put("blackthorn", "Prunus spinosa");
                this.put("black_cherry", "Prunus serotina");
                this.put("black_locust", "Robinia pseudoacacia");
                this.put("blue_mahoe", "Talipariti elatum");
                this.put("boxwood", "Buxus sempervirens");
                this.put("brazilwood", "Paubrasilia echinata");
                this.put("brazil_nut", "Bertholletia excelsa");
                this.put("breadfruit", "Artocarpus altilis");
                this.put("buddhas_hand", "Citrus medica var. sarcodactylis");
                this.put("bull_pine", "Pinus ponderosa");
                this.put("butternut", "Juglans cinerea");
                this.put("cacao", "Theobroma cacao");
                this.put("candlenut", "Aleurites moluccanus");
                this.put("carob", "Ceratonia siliqua");
                this.put("cashew", "Anacardium occidentale");
                this.put("cedar", "Cedrus libani");
                this.put("cempedak", "Artocarpus integer");
                this.put("ceylon_ebony", "Diospyros ebenum");
                this.put("cherry_plum", "Prunus cerasifera");
                this.put("cinnamon", "Cinnamomum verum");
                this.put("citron", "Citrus medica");
                this.put("copper_beech", "Fagus sylvatica purpurea");
                this.put("cork_oak", "Quercus suber");
                this.put("clove", "Syzygium aromaticum");
                this.put("cocobolo", "Dalbergia retusa");
                this.put("coconut", "Cocos nucifera");
                this.put("coffea", "Coffea arabica");
                this.put("copoazu", "Theobroma grandiflorum");
                this.put("cultivated_pear", "Pyrus communis");
                this.put("date_palm", "Phoenix dactylifera");
                this.put("dogwood", "Cornus florida");
                this.put("douglas_fir", "Pseudotsuga menziesii");
                this.put("elm", "Ulmus laevis");
                this.put("european_larch", "Larix decidua");
                this.put("finger_lime", "Citrus australasica");
                this.put("flowering_crabapple", "Malus floribunda");
                this.put("ginkgo", "Ginkgo biloba");
                this.put("golden_raspberry", "Rubus ellipticus");
                this.put("gooseberry", "Ribes uva-crispa");
                this.put("grandidiers_baobab", "Adansonia grandidieri");
                this.put("grapefruit", "Citrus paradisi");
                this.put("great_sallow", "Salix caprea");
                this.put("greenheart", "Chlorocardium rodiei");
                this.put("hawthorn", "Crataegus pinnatifida");
                this.put("hazel", "Corylus avellana");
                this.put("holly", "Ilex aquifolium");
                this.put("hornbeam", "Carpinus betulus");
                this.put("ipe", "Handroanthus albus");
                this.put("pink_ipe", "Handroanthus impetiginosus");
                this.put("purple_ipe", "Handroanthus impetiginosus");
                this.put("white_ipe", "Tabebuia roseo-alba");
                this.put("iroko", "Milicia excelsa");
                this.put("jackfruit", "Artocarpus heterophyllus");
                this.put("juniper", "Juniperus communis");
                this.put("kadsura", "Kadsura japonica");
                this.put("kapok", "Bombax ceiba");
                this.put("key_lime", "Citrus aurantiifolia");
                this.put("kumquat", "Citrus hindsii");
                this.put("lawson_cypress", "Chamaecyparis lawsoniana");
                this.put("lemon", "Citrus limon");
                this.put("lime", "Citrus limetta");
                this.put("loblolly_pine", "Pinus taeda");
                this.put("logwood", "Haematoxylum campechianum");
                this.put("mahogany", "Swietenia mahagoni");
                this.put("mandarin", "Citrus reticulata");
                this.put("mango", "Mangifera indica");
                this.put("miracle_berry", "Synsepalum dulcificum");
                this.put("monkey_puzzle", "Araucaria araucana");
                this.put("myrtle_ebony", "Diospyros pentamera");
                this.put("purple_crepe_myrtle", "Lagerstroemia indica");
                this.put("moonlight_magic_crepe_myrtle", "Lagerstroemia indica 'PIILAG-IV'");
                this.put("red_crepe_myrtle", "Lagerstroemia indica 'Whit II'");
                this.put("tuscarora_crepe_myrtle", "Lagerstroemia indica 'Tuscarora'");
                this.put("nectarine", "Prunus var. nectarina");
                this.put("nutmeg", "Myristica fragrans");
                this.put("old_fustic", "Maclura tinctoria");
                this.put("olive", "Olea europaea");
                this.put("orange", "Citrus sinensis");
                this.put("beliy_naliv_apple", "Malus domestica 'White Cloud'");
                this.put("golden_delicious_apple", "Malus domestica 'Golden Delicious'");
                this.put("granny_smith_apple", "Malus domestica 'Granny Smith'");
                this.put("red_delicious_apple", "Malus domestica 'Red Delicious'");
                this.put("osage_orange", "Maclura pomifera");
                this.put("padauk", "Pterocarpus soyauxii");
                this.put("pandanus", "Pandanus tectorius");
                this.put("papaya", "Carica papaya");
                this.put("peach", "Prunus persica");
                this.put("pecan", "Carya illinoinensis");
                this.put("persimmon", "Diospyros kaki");
                this.put("pink_ivory", "Phyllogeiton zeyheri");
                this.put("pistachio", "Pistacia vera");
                this.put("plantain", "Musa paradisiaca");
                this.put("plum", "Prunus domestica");
                this.put("pomegranate", "Punica granatum");
                this.put("pomelo", "Citrus maxima");
                this.put("prairie_crabapple", "Malus ioensis");
                this.put("purpleheart", "Peltogyne purpurea");
                this.put("purple_blackthorn", "Prunus spinosa purpurea");
                this.put("rainbow_gum", "Eucalyptus deglupta");
                this.put("raspberry", "Rubus idaeus");
                this.put("redcurrant", "Ribes rubrum");
                this.put("red_banana", "Musa acuminata");
                this.put("red_maple", "Acer rubrum");
                this.put("rosewood", "Dalbergia nigra");
                this.put("rose_gum", "Eucalyptus grandis");
                this.put("rowan", "Sorbus aucuparia");
                this.put("rubber_tree", "Hevea brasiliensis");
                this.put("salak", "Salacca zalacca");
                this.put("sandalwood", "Santalum album");
                this.put("sand_pear", "Pyrus pyrifolia");
                this.put("satsuma", "Citrus unshiu");
                this.put("sequoia", "Sequoiadendron giganteum");
                this.put("silver_fir", "Abies alba");
                this.put("silver_lime", "Tilia tomentosa");
                this.put("socotra_dragon", "Dracaena cinnabari");
                this.put("soursop", "Annona muricata");
                this.put("sour_cherry", "Prunus cerasus");
                this.put("starfruit", "Averrhoa carambola");
                this.put("star_anise", "Illicium verum");
                this.put("sugar_apple", "Annona squamosa");
                this.put("sugar_maple", "Acer saccharum");
                this.put("swamp_gum", "Eucalyptus camphora");
                this.put("sweetgum", "Liquidambar styraciflua");
                this.put("sweet_chestnut", "Castanea sativa");
                this.put("sweet_crabapple", "Malus coronaria");
                this.put("sycamore_fig", "Ficus sycomorus");
                this.put("tangerine", "Citrus tangerina");
                this.put("teak", "Tectona grandis");
                this.put("walnut", "Juglans regia");
                this.put("wenge", "Millettia laurentii");
                this.put("western_hemlock", "Tsuga heterophylla");
                this.put("whitebeam", "Aria edulis");
                this.put("white_poplar", "Populus alba");
                this.put("white_willow", "Salix alba");
                this.put("wild_cherry", "Prunus avium");
                this.put("yellow_meranti", "Shorea faguetiana");
                this.put("yew", "Taxus baccata");
                this.put("zebrano", "Microberlinia brazzavillensis");
                this.put("elderberry", "Sambucus nigra");
                this.put("star_fruit", "Averrhoa carambola");
                this.put("black_ember", "Ignis obscurum");
                this.put("brown_amber", "Umbra electri");
                this.put("cave_dweller", "Specus habitatoria");
                this.put("firecracker", "Scintillat calamus");
                this.put("flickering_sun", "Stella coruscatio");
                this.put("foggy_blast", "Nebula inflatus");
                this.put("purple_spiral", "Ysabella purpurea");
                this.put("rippling_willow", "Salix fluctus");
                this.put("slimy_delight", "Salivarius delicium");
                this.put("sparkle_cherry", "Prunus splendico");
                this.put("soul_tree", "Aevum viatora");
                this.put("thunder_bolt", "");
                this.put("blue_yonder", "Stella caelus");
                this.put("time_traveller", "Aevum viatora");
                this.put("water_wonder", "Aevum viatora");
                this.put("night_fuchsia", "Fuchsia nox");
            }
        };
        return (String)names.get(name);
    }
}

