/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.integrations.jei;

import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.integrations.jei.LogStrippingRecipeCategory;
import cy.jdkdigital.productivetrees.integrations.jei.SawmillRecipeCategory;
import cy.jdkdigital.productivetrees.integrations.jei.TreeFruitingRecipeCategory;
import cy.jdkdigital.productivetrees.integrations.jei.TreePollinationRecipeCategory;
import cy.jdkdigital.productivetrees.recipe.LogStrippingRecipe;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.recipe.TreeFruitingRecipe;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRuntimeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ProductiveTreesJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"productivetrees");
    public static final RecipeType<TreePollinationRecipe> TREE_POLLINATION_TYPE = RecipeType.create((String)"productivetrees", (String)"tree_pollination", TreePollinationRecipe.class);
    public static final RecipeType<TreeFruitingRecipe> TREE_FRUITING_TYPE = RecipeType.create((String)"productivetrees", (String)"tree_fruiting", TreeFruitingRecipe.class);
    public static final RecipeType<LogStrippingRecipe> LOG_STRIPPING_TYPE = RecipeType.create((String)"productivetrees", (String)"log_stripping", LogStrippingRecipe.class);
    public static final RecipeType<SawmillRecipe> SAWMILL_TYPE = RecipeType.create((String)"productivetrees", (String)"sawmill", SawmillRecipe.class);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TreeRegistrator.POLLEN.get()), new RecipeType[]{TREE_POLLINATION_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TreeRegistrator.STRIPPER.get()), new RecipeType[]{LOG_STRIPPING_TYPE});
        Arrays.stream(Ingredient.of(ModTags.STRIPPER_TOOLS).getItems()).forEach(itemStack -> registration.addRecipeCatalyst(itemStack.copy(), new RecipeType[]{LOG_STRIPPING_TYPE}));
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TreeRegistrator.SAWMILL.get()), new RecipeType[]{SAWMILL_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new TreePollinationRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new TreeFruitingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new LogStrippingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SawmillRecipeCategory(guiHelper)});
    }

    public void registerRuntime(IRuntimeRegistration registration) {
        ArrayList mutationTrees = new ArrayList();
        TreeFinder.trees.forEach((id, treeObject) -> {
            if (!treeObject.getMutationInfo().target().equals((Object)ProductiveTrees.EMPTY_RL)) {
                mutationTrees.add(treeObject.getMutationInfo().target().getPath());
            }
        });
        ArrayList hiddenTrees = new ArrayList();
        ProductiveTrees.ITEMS.getEntries().forEach(item -> mutationTrees.forEach(s -> {
            if (item.getId().getPath().startsWith((String)s)) {
                hiddenTrees.add(new ItemStack((ItemLike)item.get()));
            }
        }));
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hiddenTrees);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List pollinationRecipeList = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)TreeRegistrator.TREE_POLLINATION_TYPE.get());
        registration.addRecipes(TREE_POLLINATION_TYPE, pollinationRecipeList.stream().map(RecipeHolder::value).toList());
        ArrayList fruitingRecipeList = new ArrayList();
        TreeFinder.trees.forEach((id, treeObject) -> {
            if (treeObject.hasFruit()) {
                fruitingRecipeList.add(new TreeFruitingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{TreeUtil.getBlock(id, "_sapling")}), treeObject.getFruit().getItem().copy()));
            }
        });
        registration.addRecipes(TREE_FRUITING_TYPE, fruitingRecipeList);
        List<LogStrippingRecipe> jsonRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)TreeRegistrator.LOG_STRIPPING_TYPE.get()).stream().map(RecipeHolder::value).toList();
        ArrayList<LogStrippingRecipe> stripList = new ArrayList<LogStrippingRecipe>(jsonRecipes);
        Arrays.stream(Ingredient.of((TagKey)ItemTags.LOGS).getItems()).forEach(itemStack -> {
            ItemStack stripped = TreeUtil.getStrippedItem(itemStack);
            if (!stripped.isEmpty() && !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)stripped)) {
                BlockItem blockItem;
                TreeObject tree;
                ItemStack secondary = ItemStack.EMPTY;
                Item patt0$temp = itemStack.getItem();
                if (patt0$temp instanceof BlockItem && (tree = TreeUtil.getTree((blockItem = (BlockItem)patt0$temp).getBlock())) != null && tree.getStripDrop().isPresent()) {
                    secondary = tree.getStripDropStack();
                }
                stripList.add(new LogStrippingRecipe((ItemStack)itemStack, stripped, secondary));
            }
        });
        registration.addRecipes(LOG_STRIPPING_TYPE, stripList);
        List sawmillRecipeList = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)TreeRegistrator.SAW_MILLLING_TYPE.get());
        registration.addRecipes(SAWMILL_TYPE, sawmillRecipeList.stream().map(RecipeHolder::value).toList());
    }
}

