/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.inventory;

import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import cy.jdkdigital.productivetrees.common.block.entity.WoodWorkerBlockEntity;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WoodWorkerContainer
extends AbstractContainer<WoodWorkerBlockEntity> {
    public WoodWorkerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, WoodWorkerContainer.getTileEntity(playerInventory, data));
    }

    public WoodWorkerContainer(int windowId, Inventory playerInventory, WoodWorkerBlockEntity blockEntity) {
        super((MenuType)TreeRegistrator.WOOD_WORKER_MENU.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((WoodWorkerBlockEntity)this.getBlockEntity()).getItemHandler(), WoodWorkerBlockEntity.SLOT_IN, 44, 25));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((WoodWorkerBlockEntity)this.getBlockEntity()).getItemHandler(), WoodWorkerBlockEntity.SLOT_AXE, 44, 44));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((WoodWorkerBlockEntity)this.getBlockEntity()).getItemHandler(), WoodWorkerBlockEntity.SLOT_OUT, 116, 34));
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static WoodWorkerBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof WoodWorkerBlockEntity) {
            return (WoodWorkerBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

