/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.blocks;

import com.mojang.serialization.MapCodec;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PinkVinesBlock
extends GrowingPlantHeadBlock {
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final MapCodec<PinkVinesBlock> CODEC = PinkVinesBlock.simpleCodec(PinkVinesBlock::new);

    public PinkVinesBlock(BlockBehaviour.Properties props) {
        super(props, Direction.DOWN, SHAPE, false, 0.0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<PinkVinesBlock> codec() {
        return CODEC;
    }

    protected Block getBodyBlock() {
        return (Block)PVJBlocks.PINK_VINES_PLANT.get();
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource randomSource) {
        return 1;
    }

    protected boolean canGrowInto(BlockState p_152998_) {
        return p_152998_.isAir();
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.relative(this.growthDirection.getOpposite());
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return blockstate.is((Block)this.getHeadBlock()) || blockstate.is(this.getBodyBlock()) || blockstate.is(BlockTags.LEAVES);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        BlockPos blockpos;
        BlockState blockstate;
        super.animateTick(state, level, pos, randomSource);
        if (randomSource.nextInt(10) == 0 && !PinkVinesBlock.isFaceFull((VoxelShape)(blockstate = level.getBlockState(blockpos = pos.below())).getCollisionShape((BlockGetter)level, blockpos), (Direction)Direction.UP)) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)randomSource, (ParticleOptions)ParticleTypes.CHERRY_LEAVES);
        }
    }
}

