/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.source.builtin.BreakBlockExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.CraftItemExperienceSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"onCraftedBy(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;I)V"}, at={@At(value="HEAD")})
    private void injectAtOnCraftByPlayer(Level world, Player player, int amount, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SkillsAPI.updateExperienceSources(serverPlayer, CraftItemExperienceSource.class, es -> (int)Math.round(es.calculation().evaluate(new CraftItemExperienceSource.Data(serverPlayer, (ItemStack)this)) * (double)amount));
        }
    }

    @Inject(method={"mineBlock(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")})
    private void injectAtPostMine(Level world, BlockState state, BlockPos pos, Player player, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SkillsAPI.updateExperienceSources(serverPlayer, BreakBlockExperienceSource.class, experienceSource -> (int)Math.round(experienceSource.calculation().evaluate(new BreakBlockExperienceSource.Data(serverPlayer, state, (ItemStack)this))));
        }
    }
}

