/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.builder;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.permutated.pylons.builder.RecipeException;
import net.permutated.pylons.recipe.HarvestingRecipe;

public class HarvestingRecipeBuilder {
    private final Block input;
    private ItemStack output;

    protected String getPrefix() {
        return "harvesting";
    }

    public HarvestingRecipeBuilder(Block input) {
        this.input = input;
    }

    public static HarvestingRecipeBuilder forBlock(Block block) {
        return new HarvestingRecipeBuilder(block);
    }

    public HarvestingRecipeBuilder setOutput(Item item, int count) {
        this.output = new ItemStack((ItemLike)item, count);
        return this;
    }

    public void build(RecipeOutput consumer) {
        String modId = BuiltInRegistries.BLOCK.getKey((Object)this.input).getNamespace();
        String path = BuiltInRegistries.BLOCK.getKey((Object)this.input).getPath();
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"pylons", (String)(this.getPrefix() + "/" + modId + "/" + path));
        if (this.output == null) {
            throw new RecipeException(id.toString(), "output is required");
        }
        consumer.withConditions(new ICondition[]{new ModLoadedCondition(modId)}).accept(id, (Recipe)new HarvestingRecipe(this.input, this.output), null);
    }
}

