/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.harvester;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.permutated.pylons.machines.base.AbstractPylonScreen;
import net.permutated.pylons.machines.harvester.HarvesterPylonContainer;
import net.permutated.pylons.machines.harvester.HarvesterPylonTile;

public class HarvesterPylonScreen
extends AbstractPylonScreen<HarvesterPylonContainer> {
    public HarvesterPylonScreen(HarvesterPylonContainer container, Inventory inv, Component name) {
        super(container, inv, name, HarvesterPylonTile.requiresPower());
    }

    @Override
    protected Tooltip rangeButtonTooltip() {
        return Tooltip.create((Component)this.translate("workAreaBlocks"));
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        switch (((HarvesterPylonContainer)this.menu).getWorkStatus()) {
            case MISSING_INVENTORY: {
                this.drawText(graphics, (Component)this.translate("inventoryMissing").withStyle(ChatFormatting.RED), 42);
                break;
            }
            case MISSING_TOOL: {
                this.drawText(graphics, (Component)this.translate("toolMissing").withStyle(ChatFormatting.RED), 42);
                break;
            }
            case MISSING_ENERGY: {
                this.drawText(graphics, (Component)this.translate("energyMissing").withStyle(ChatFormatting.RED), 42);
                break;
            }
            case INVENTORY_FULL: {
                this.drawText(graphics, (Component)this.translate("inventoryFull").withStyle(ChatFormatting.RED), 42);
                break;
            }
            case WORKING: {
                this.drawText(graphics, (Component)this.translate("working").withStyle(ChatFormatting.DARK_GREEN), 42);
            }
        }
    }
}

