/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.permutated.pylons.util.Location;
import net.permutated.pylons.util.Range;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(modid="pylons")
public class ProtectionManager {
    private static boolean dirty = false;
    private static Map<Location, Set<Filter>> chunkMap = new ConcurrentHashMap<Location, Set<Filter>>();
    private static final Map<Location, Pair<Set<Location>, Set<Filter>>> pylonMap = new ConcurrentHashMap<Location, Pair<Set<Location>, Set<Filter>>>();

    private ProtectionManager() {
    }

    public static Filter mobFilter(UUID owner, ResourceLocation location) {
        return new MobFilter(owner, location);
    }

    public static Filter blockFilter(UUID owner, ResourceLocation location) {
        return new BlockFilter(owner, location);
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (dirty) {
            ConcurrentHashMap<Location, Set<Filter>> replace = new ConcurrentHashMap<Location, Set<Filter>>();
            pylonMap.values().forEach(pair -> ((Set)pair.getLeft()).forEach(location -> replace.merge((Location)location, (Set)pair.getRight(), Sets::union)));
            chunkMap = replace;
            dirty = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getTarget();
        if (entity2 instanceof LivingEntity && (entity2 = (entity = (LivingEntity)entity2).level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)entity2;
            int chunkX = SectionPos.posToSectionCoord((double)entity.getX());
            int chunkZ = SectionPos.posToSectionCoord((double)entity.getZ());
            Location location = new Location((ResourceKey<Level>)level.dimension(), BlockPos.ZERO, chunkX, chunkZ);
            Set<Filter> filterSet = chunkMap.get(location);
            if (filterSet == null) {
                return;
            }
            UUID player = event.getEntity().getUUID();
            ResourceLocation target = BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getTarget().getType());
            for (Filter filter : filterSet) {
                if (!(filter instanceof MobFilter) || !filter.matches(player, target)) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingIncomingDamageEvent(LivingIncomingDamageEvent event) {
        Level level = event.getEntity().level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel level2 = (ServerLevel)level;
            int chunkX = SectionPos.posToSectionCoord((double)event.getEntity().getX());
            int chunkZ = SectionPos.posToSectionCoord((double)event.getEntity().getZ());
            Location location = new Location((ResourceKey<Level>)level2.dimension(), BlockPos.ZERO, chunkX, chunkZ);
            Set<Filter> filterSet = chunkMap.get(location);
            if (filterSet == null) {
                return;
            }
            DamageSource source = event.getSource();
            Entity entity2 = entity = source.getEntity() == null ? source.getDirectEntity() : source.getEntity();
            if (entity instanceof Player) {
                UUID player = entity.getUUID();
                ResourceLocation target = BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType());
                for (Filter filter : filterSet) {
                    if (!(filter instanceof MobFilter) || !filter.matches(player, target)) continue;
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            int chunkX = SectionPos.posToSectionCoord((double)event.getPos().getX());
            int chunkZ = SectionPos.posToSectionCoord((double)event.getPos().getZ());
            Location location = new Location((ResourceKey<Level>)level.dimension(), BlockPos.ZERO, chunkX, chunkZ);
            Set<Filter> filterSet = chunkMap.get(location);
            if (filterSet == null) {
                return;
            }
            UUID player = event.getPlayer().getUUID();
            ResourceLocation target = BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(event.getPos()).getBlock());
            for (Filter filter : filterSet) {
                if (!(filter instanceof BlockFilter) || !filter.matches(player, target)) continue;
                event.setCanceled(true);
            }
        }
    }

    public static void register(ServerLevel level, BlockPos blockPos, Range range, Collection<Filter> filters) {
        if (filters.isEmpty()) {
            ProtectionManager.unregister(level, blockPos);
            return;
        }
        Location pylon = Location.of(level, blockPos);
        Set<Location> locations = Location.chunkSet(level, blockPos, range);
        pylonMap.put(pylon, (Pair<Set<Location>, Set<Filter>>)Pair.of(locations, (Object)ImmutableSet.copyOf(filters)));
        dirty = true;
    }

    public static void unregister(ServerLevel level, BlockPos blockPos) {
        Location pylon = Location.of(level, blockPos);
        pylonMap.remove(pylon);
        dirty = true;
    }

    record MobFilter(UUID owner, ResourceLocation filter) implements Filter
    {
        @Override
        public boolean matches(UUID player, ResourceLocation location) {
            return this.owner.equals(player) && this.filter.equals((Object)location);
        }
    }

    record BlockFilter(UUID owner, ResourceLocation filter) implements Filter
    {
        @Override
        public boolean matches(UUID player, ResourceLocation location) {
            return this.owner.equals(player) && this.filter.equals((Object)location);
        }
    }

    public static interface Filter {
        public boolean matches(UUID var1, ResourceLocation var2);
    }
}

