/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wile.redstonepen.libmc.Auxiliaries;

public class StandardItems {

    public static class BaseBlockItem
    extends BlockItem {
        public BaseBlockItem(Block block, Item.Properties properties) {
            super(block, properties);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, ctx, tooltip, flag, true);
        }

        public InteractionResult useOn(UseOnContext context) {
            InteractionResult ir = this.onItemUseFirst(context.getItemInHand(), context);
            if (ir != InteractionResult.PASS) {
                return ir;
            }
            return super.useOn(context);
        }

        public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
            return InteractionResult.PASS;
        }
    }

    public static class BaseItem
    extends Item
    implements IStandardItem {
        public BaseItem(Item.Properties properties) {
            super(properties);
        }

        public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
            return false;
        }

        public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
            return false;
        }

        public InteractionResult useOn(UseOnContext context) {
            return this.onItemUseFirst(context.getItemInHand(), context);
        }

        public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
            return InteractionResult.PASS;
        }
    }

    public static interface IStandardItem {
    }
}

