/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;

public class ResourceContainerChemicalHandlerAdapter
implements IChemicalHandler {
    private final ResourceContainer container;

    public ResourceContainerChemicalHandlerAdapter(ResourceContainer container) {
        this.container = container;
    }

    public int getChemicalTanks() {
        return this.container.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChemicalStack getChemicalInTank(int tank) {
        Chemical chemical;
        ResourceKey resourceKey;
        ResourceAmount resourceAmount = this.container.get(tank);
        if (resourceAmount == null || !((resourceKey = resourceAmount.resource()) instanceof ChemicalResource)) return ChemicalStack.EMPTY;
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical2;
            chemical = chemical2 = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return new ChemicalStack(chemical, resourceAmount.amount());
    }

    public void setChemicalInTank(int tank, ChemicalStack chemicalStack) {
        if (chemicalStack.isEmpty()) {
            this.container.remove(tank);
        } else {
            long amount = Math.min(chemicalStack.getAmount(), ChemicalResourceType.INSTANCE.getInterfaceExportLimit());
            this.container.set(tank, new ResourceAmount((ResourceKey)ChemicalResource.ofChemicalStack(chemicalStack), amount));
        }
    }

    public long getChemicalTankCapacity(int tank) {
        PlatformResourceKey resource = this.container.getResource(tank);
        if (resource == null || resource instanceof ChemicalResource) {
            return ChemicalResourceType.INSTANCE.getInterfaceExportLimit();
        }
        return 0L;
    }

    public boolean isValid(int tank, ChemicalStack chemicalStack) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChemicalStack insertChemical(int tank, ChemicalStack chemicalStack, Action action) {
        Chemical otherChemical;
        ResourceAmount currentResource = this.container.get(tank);
        if (currentResource == null) {
            return this.insertChemicalInEmptyTank(tank, chemicalStack, action);
        }
        ResourceKey resourceKey = currentResource.resource();
        if (!(resourceKey instanceof ChemicalResource)) return chemicalStack;
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical;
            otherChemical = chemical = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (otherChemical != chemicalStack.getChemical()) return chemicalStack;
        return this.insertChemicalInFilledTank(tank, chemicalStack, action, currentResource);
    }

    private ChemicalStack insertChemicalInFilledTank(int tank, ChemicalStack chemicalStack, Action action, ResourceAmount currentResource) {
        long remainder;
        long currentAmount = currentResource.amount();
        long toInsert = Math.min(chemicalStack.getAmount(), ChemicalResourceType.INSTANCE.getInterfaceExportLimit() - currentAmount);
        if (toInsert <= 0L) {
            return chemicalStack;
        }
        if (action == Action.EXECUTE) {
            this.container.set(tank, new ResourceAmount(currentResource.resource(), currentAmount + toInsert));
        }
        if ((remainder = chemicalStack.getAmount() - toInsert) <= 0L) {
            return ChemicalStack.EMPTY;
        }
        return new ChemicalStack(chemicalStack.getChemical(), remainder);
    }

    private ChemicalStack insertChemicalInEmptyTank(int tank, ChemicalStack chemicalStack, Action action) {
        long remainder;
        long toInsert = Math.min(chemicalStack.getAmount(), ChemicalResourceType.INSTANCE.getInterfaceExportLimit());
        if (action == Action.EXECUTE) {
            this.container.set(tank, new ResourceAmount((ResourceKey)ChemicalResource.ofChemicalStack(chemicalStack), toInsert));
        }
        if ((remainder = chemicalStack.getAmount() - toInsert) <= 0L) {
            return ChemicalStack.EMPTY;
        }
        return new ChemicalStack(chemicalStack.getChemical(), remainder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        Chemical chemical;
        ResourceKey resourceKey;
        if (amount <= 0L) {
            return ChemicalStack.EMPTY;
        }
        ResourceAmount currentResource = this.container.get(tank);
        if (currentResource == null || !((resourceKey = currentResource.resource()) instanceof ChemicalResource)) return ChemicalStack.EMPTY;
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical2;
            chemical = chemical2 = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        long toExtract = Math.min(amount, currentResource.amount());
        if (toExtract <= 0L) {
            return ChemicalStack.EMPTY;
        }
        if (action != Action.EXECUTE) return new ChemicalStack(chemical, toExtract);
        this.container.shrink(tank, toExtract);
        return new ChemicalStack(chemical, toExtract);
    }
}

