/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.importer;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.ImporterSource;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.TransferHelper;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.ToLongFunction;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.2.1")
public class ImporterTransferStrategyImpl
implements ImporterTransferStrategy {
    private final ImporterSource source;
    private final ToLongFunction<ResourceKey> transferQuotaProvider;

    public ImporterTransferStrategyImpl(ImporterSource source, ToLongFunction<ResourceKey> transferQuotaProvider) {
        this.source = source;
        this.transferQuotaProvider = transferQuotaProvider;
    }

    @Override
    public boolean transfer(Filter filter, Actor actor, Network network) {
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        return this.transfer(filter, actor, rootStorage);
    }

    private boolean transfer(Filter filter, Actor actor, RootStorage rootStorage) {
        long total = 0L;
        long transferQuota = 0L;
        ResourceKey workingResource = null;
        Iterator<ResourceKey> iterator = this.source.getResources();
        while (iterator.hasNext() && (total < transferQuota || transferQuota == 0L)) {
            long transferred;
            ResourceKey resource = iterator.next();
            if (workingResource != null) {
                total += this.transfer(rootStorage, actor, transferQuota, total, workingResource, resource);
                continue;
            }
            if (!filter.isAllowed(resource)) continue;
            transferQuota = this.transferQuotaProvider.applyAsLong(resource);
            long l = transferred = transferQuota > 0L ? this.transfer(rootStorage, actor, transferQuota, total, resource) : 0L;
            if (transferred > 0L) {
                workingResource = resource;
            }
            total += transferred;
        }
        return total > 0L;
    }

    private long transfer(RootStorage rootStorage, Actor actor, long transferQuota, long total, ResourceKey workingResource, ResourceKey resource) {
        return Objects.equals(workingResource, resource) ? this.transfer(rootStorage, actor, transferQuota, total, resource) : 0L;
    }

    private long transfer(RootStorage rootStorage, Actor actor, long transferQuota, long total, ResourceKey resource) {
        return TransferHelper.transfer(resource, transferQuota - total, actor, this.source, rootStorage, this.source);
    }
}

