/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.patternprovider;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskListener;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.ParentContainer;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.api.network.impl.autocrafting.TaskContainer;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.ExternalPatternSinkKeyProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderListener;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class PatternProviderNetworkNode
extends SimpleNetworkNode
implements PatternProvider,
TaskListener {
    private final Pattern[] patterns;
    private final Set<ParentContainer> parents = new HashSet<ParentContainer>();
    private final TaskContainer tasks = new TaskContainer(this);
    private int priority;
    @Nullable
    private PatternProviderExternalPatternSink sink;
    @Nullable
    private ExternalPatternSinkKeyProvider sinkKeyProvider;
    private StepBehavior stepBehavior = StepBehavior.DEFAULT;
    @Nullable
    private PatternProviderListener listener;

    public PatternProviderNetworkNode(long energyUsage, int patterns) {
        super(energyUsage);
        this.patterns = new Pattern[patterns];
    }

    public void setSink(PatternProviderExternalPatternSink sink) {
        this.sink = sink;
    }

    public void setPattern(int index, @Nullable Pattern pattern) {
        Pattern oldPattern = this.patterns[index];
        if (oldPattern != null) {
            this.parents.forEach(parent -> parent.remove(this, oldPattern));
        }
        this.patterns[index] = pattern;
        if (pattern != null) {
            this.parents.forEach(parent -> parent.add(this, pattern, this.priority));
        }
    }

    @Override
    public void setNetwork(@Nullable Network network) {
        if (this.network != null) {
            this.tasks.detachAll(this.network);
        }
        super.setNetwork(network);
        if (network != null) {
            this.tasks.attachAll(network);
        }
    }

    @Override
    protected void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        if (!newActive) {
            for (Pattern pattern : this.patterns) {
                if (pattern == null) continue;
                this.parents.forEach(parent -> parent.remove(this, pattern));
            }
            return;
        }
        for (Pattern pattern : this.patterns) {
            if (pattern == null) continue;
            this.parents.forEach(parent -> parent.add(this, pattern, this.priority));
        }
    }

    @Override
    public void onAddedIntoContainer(ParentContainer parentContainer) {
        this.parents.add(parentContainer);
        this.tasks.onAddedIntoContainer(parentContainer);
        for (Pattern pattern : this.patterns) {
            if (pattern == null) continue;
            parentContainer.add(this, pattern, this.priority);
        }
    }

    @Override
    public void onRemovedFromContainer(ParentContainer parentContainer) {
        this.tasks.onRemovedFromContainer(parentContainer);
        this.parents.remove(parentContainer);
        for (Pattern pattern : this.patterns) {
            if (pattern == null) continue;
            parentContainer.remove(this, pattern);
        }
    }

    @Override
    public void addTask(Task task) {
        this.tasks.add(task, this.network);
        this.parents.forEach(parent -> parent.taskAdded(this, task));
    }

    @Override
    public void cancelTask(TaskId taskId) {
        this.tasks.cancel(taskId);
    }

    @Override
    public List<TaskStatus> getTaskStatuses() {
        return this.tasks.getStatuses();
    }

    @Override
    public long getAmount(ResourceKey resource) {
        return this.tasks.getAmount(resource);
    }

    @Override
    public void receivedExternalIteration() {
        if (this.listener != null) {
            this.listener.receivedExternalIteration();
        }
    }

    @Override
    public void receivedExternalIteration(Pattern pattern) {
        if (this.network == null) {
            return;
        }
        AutocraftingNetworkComponent autocrafting = this.network.getComponent(AutocraftingNetworkComponent.class);
        PatternProvider provider = autocrafting.getProviderByPattern(pattern);
        if (provider == null) {
            return;
        }
        provider.receivedExternalIteration();
    }

    @Override
    public ExternalPatternSink.Result accept(Pattern pattern, Collection<ResourceAmount> resources, Action action) {
        if (this.sink == null) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        return this.sink.accept(resources, action);
    }

    public List<Task> getTasks() {
        return this.tasks.getAll();
    }

    @Override
    public void doWork() {
        super.doWork();
        if (this.network == null || !this.isActive()) {
            return;
        }
        this.tasks.step(this.network, this.stepBehavior, this);
    }

    @Override
    @Nullable
    public ExternalPatternSinkKey getKey() {
        return this.sinkKeyProvider != null ? this.sinkKeyProvider.getKey() : null;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        for (Pattern pattern : this.patterns) {
            if (pattern == null) continue;
            this.parents.forEach(parent -> parent.update(pattern, priority));
        }
    }

    public void setStepBehavior(StepBehavior stepBehavior) {
        this.stepBehavior = stepBehavior;
    }

    public void setSinkKeyProvider(ExternalPatternSinkKeyProvider provider) {
        this.sinkKeyProvider = provider;
    }

    public void setListener(PatternProviderListener listener) {
        this.listener = listener;
    }
}

