/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.WirelessGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.WirelessGridData;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

class WirelessGridExtendedMenuProvider
implements ExtendedMenuProvider<WirelessGridData> {
    private final Component name;
    private final Grid grid;
    private final SlotReference slotReference;

    WirelessGridExtendedMenuProvider(Component name, Grid grid, SlotReference slotReference) {
        this.name = name;
        this.grid = grid;
        this.slotReference = slotReference;
    }

    @Override
    public WirelessGridData getMenuData() {
        return new WirelessGridData(GridData.of(this.grid), this.slotReference);
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, WirelessGridData> getMenuCodec() {
        return WirelessGridData.STREAM_CODEC;
    }

    public Component getDisplayName() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new WirelessGridContainerMenu(syncId, inventory, this.grid, this.slotReference);
    }
}

