/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.screen;

import com.refinedmods.refinedstorage.api.resource.repository.SortingDirection;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class SortingDirectionSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "grid.sorting.direction");
    private static final List<MutableComponent> SUBTEXT_ASCENDING = List.of(IdentifierUtil.createTranslation("gui", "grid.sorting.direction.ascending").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_DESCENDING = List.of(IdentifierUtil.createTranslation("gui", "grid.sorting.direction.descending").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation ASCENDING = IdentifierUtil.createIdentifier("widget/side_button/grid/sorting_direction/ascending");
    private static final ResourceLocation DESCENDING = IdentifierUtil.createIdentifier("widget/side_button/grid/sorting_direction/descending");
    private final AbstractGridContainerMenu menu;

    SortingDirectionSideButtonWidget(AbstractGridContainerMenu menu) {
        super(SortingDirectionSideButtonWidget.createPressAction(menu));
        this.menu = menu;
    }

    private static Button.OnPress createPressAction(AbstractGridContainerMenu menu) {
        return btn -> menu.setSortingDirection(SortingDirectionSideButtonWidget.toggle(menu.getSortingDirection()));
    }

    private static SortingDirection toggle(SortingDirection sortingDirection) {
        return sortingDirection == SortingDirection.ASCENDING ? SortingDirection.DESCENDING : SortingDirection.ASCENDING;
    }

    @Override
    protected ResourceLocation getSprite() {
        return this.menu.getSortingDirection() == SortingDirection.ASCENDING ? ASCENDING : DESCENDING;
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return switch (this.menu.getSortingDirection()) {
            default -> throw new MatchException(null, null);
            case SortingDirection.ASCENDING -> SUBTEXT_ASCENDING;
            case SortingDirection.DESCENDING -> SUBTEXT_DESCENDING;
        };
    }
}

