/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStorageRepository
implements StorageRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStorageRepository.class);
    private final Map<UUID, ClientStorageInfo> info = new HashMap<UUID, ClientStorageInfo>();
    private final Consumer<UUID> storageInfoRequestAcceptor;

    public ClientStorageRepository(Consumer<UUID> storageInfoRequestAcceptor) {
        this.storageInfoRequestAcceptor = CoreValidations.validateNotNull(storageInfoRequestAcceptor, "Storage info request acceptor cannot be null");
    }

    @Override
    public Optional<SerializableStorage> get(UUID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(UUID id, SerializableStorage storage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<SerializableStorage> removeIfEmpty(UUID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(UUID id) {
        throw new UnsupportedOperationException();
    }

    private ClientStorageInfo getOrCreateClientInfo(UUID id) {
        return this.info.computeIfAbsent(id, k -> new ClientStorageInfo());
    }

    public void updateInfo(UUID id, long stored, long capacity) {
        this.getOrCreateClientInfo((UUID)id).info = new StorageInfo(stored, capacity);
    }

    @Override
    public StorageInfo getInfo(UUID id) {
        ClientStorageInfo clientInfo = this.getOrCreateClientInfo(id);
        this.trySendRequestPacket(id, clientInfo.rateLimiter);
        return clientInfo.info;
    }

    private void trySendRequestPacket(UUID id, RateLimiter rateLimiter) {
        if (!rateLimiter.tryAcquire()) {
            return;
        }
        LOGGER.debug("Sending storage info request packet for {}", (Object)id);
        this.storageInfoRequestAcceptor.accept(id);
    }

    @Override
    public void markAsChanged() {
        throw new UnsupportedOperationException();
    }

    private static class ClientStorageInfo {
        private final RateLimiter rateLimiter = RateLimiter.create((double)1.0);
        private StorageInfo info = StorageInfo.UNKNOWN;

        private ClientStorageInfo() {
        }
    }
}

