/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.externalstorage;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.iface.InterfaceBlock;
import com.refinedmods.refinedstorage.common.storage.externalstorage.AbstractExternalStorageBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalCableBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.DirectionalCableBlockShapes;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExternalStorageBlock
extends AbstractDirectionalCableBlock
implements ColorableBlock<ExternalStorageBlock, BaseBlockItem>,
EntityBlock,
BlockItemProvider<BaseBlockItem> {
    private static final Component HELP = IdentifierUtil.createTranslation("item", "external_storage.help");
    private static final ConcurrentHashMap<AbstractDirectionalCableBlock.DirectionalCacheShapeCacheKey, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap();
    private static final AbstractBlockEntityTicker<AbstractExternalStorageBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(BlockEntities.INSTANCE::getExternalStorage);
    private final DyeColor color;
    private final MutableComponent name;
    private final BlockEntityProvider<AbstractExternalStorageBlockEntity> blockEntityProvider;

    public ExternalStorageBlock(DyeColor color, MutableComponent name, BlockEntityProvider<AbstractExternalStorageBlockEntity> blockEntityProvider) {
        super(SHAPE_CACHE);
        this.color = color;
        this.name = name;
        this.blockEntityProvider = blockEntityProvider;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityProvider.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return TICKER.get(level, type);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        super.neighborChanged(state, level, pos, block, fromPos, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbstractExternalStorageBlockEntity) {
                AbstractExternalStorageBlockEntity blockEntity2 = (AbstractExternalStorageBlockEntity)blockEntity;
                boolean didBreakInterfaceBlock = block instanceof InterfaceBlock;
                boolean didPlacePotentialInterfaceBlock = block instanceof AirBlock;
                if (didBreakInterfaceBlock || didPlacePotentialInterfaceBlock) {
                    blockEntity2.loadStorage(serverLevel);
                } else {
                    blockEntity2.neighborChanged();
                }
            }
        }
    }

    @Override
    public BlockColorMap<ExternalStorageBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getExternalStorage();
    }

    @Override
    protected VoxelShape getExtensionShape(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> DirectionalCableBlockShapes.EXTERNAL_STORAGE_NORTH;
            case Direction.EAST -> DirectionalCableBlockShapes.EXTERNAL_STORAGE_EAST;
            case Direction.SOUTH -> DirectionalCableBlockShapes.EXTERNAL_STORAGE_SOUTH;
            case Direction.WEST -> DirectionalCableBlockShapes.EXTERNAL_STORAGE_WEST;
            case Direction.UP -> DirectionalCableBlockShapes.EXTERNAL_STORAGE_UP;
            case Direction.DOWN -> DirectionalCableBlockShapes.EXTERNAL_STORAGE_DOWN;
        };
    }

    public MutableComponent getName() {
        return this.name;
    }

    @Override
    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem(this, HELP);
    }
}

