/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network.item;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemPlayerValidator;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemTargetBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

class NetworkItemContextImpl
implements NetworkItemContext {
    private final Player player;
    private final NetworkItemPlayerValidator.PlayerCoordinates coordinates;
    private final SlotReference slotReference;
    @Nullable
    private final GlobalPos networkLocation;

    NetworkItemContextImpl(Player player, SlotReference slotReference, @Nullable GlobalPos networkLocation) {
        this.player = player;
        this.coordinates = new NetworkItemPlayerValidator.PlayerCoordinates((ResourceKey<Level>)player.level().dimension(), new Vec3(player.position().x, player.position().y, player.position().z));
        this.slotReference = slotReference;
        this.networkLocation = networkLocation;
    }

    @Override
    public Optional<Network> resolveNetwork() {
        if (this.networkLocation == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.player.getServer()).map(server -> server.getLevel(this.networkLocation.dimension())).filter(level -> level.isLoaded(this.networkLocation.pos())).map(level -> level.getBlockEntity(this.networkLocation.pos())).filter(NetworkItemTargetBlockEntity.class::isInstance).map(NetworkItemTargetBlockEntity.class::cast).map(NetworkItemTargetBlockEntity::getNetworkForItem).filter(this::isValid);
    }

    private boolean isValid(Network network) {
        return network.getComponent(GraphNetworkComponent.class).getContainers(NetworkItemPlayerValidator.class).stream().anyMatch(validator -> validator.isValid(this.coordinates));
    }

    @Override
    public boolean isActive() {
        return this.slotReference.resolve(this.player).flatMap(Platform.INSTANCE::getEnergyStorage).map(energyStorage -> energyStorage.getStored() > 0L).orElse(true);
    }

    @Override
    public void drainEnergy(long amount) {
        this.slotReference.resolve(this.player).flatMap(Platform.INSTANCE::getEnergyStorage).ifPresent(energyStorage -> energyStorage.extract(amount, Action.EXECUTE));
    }
}

