/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage.portablegrid;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.neoforge.storage.portablegrid.DiskLedBakers;
import com.refinedmods.refinedstorage.neoforge.storage.portablegrid.PortableGridBakedModel;
import com.refinedmods.refinedstorage.neoforge.support.render.DiskModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.RotationTranslationModelBaker;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class PortableGridUnbakedGeometry
implements IUnbakedGeometry<PortableGridUnbakedGeometry> {
    private static final ResourceLocation ACTIVE_MODEL = IdentifierUtil.createIdentifier("block/portable_grid/active");
    private static final ResourceLocation INACTIVE_MODEL = IdentifierUtil.createIdentifier("block/portable_grid/inactive");
    private static final ResourceLocation INACTIVE_LED_MODEL = IdentifierUtil.createIdentifier("block/disk/led_inactive");
    private static final ResourceLocation NORMAL_LED_MODEL = IdentifierUtil.createIdentifier("block/disk/led_normal");
    private static final ResourceLocation NEAR_CAPACITY_LED_MODEL = IdentifierUtil.createIdentifier("block/disk/led_near_capacity");
    private static final ResourceLocation FULL_LED_MODEL = IdentifierUtil.createIdentifier("block/disk/led_full");

    PortableGridUnbakedGeometry() {
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        modelGetter.apply(ACTIVE_MODEL).resolveParents(modelGetter);
        modelGetter.apply(INACTIVE_MODEL).resolveParents(modelGetter);
        modelGetter.apply(INACTIVE_LED_MODEL).resolveParents(modelGetter);
        modelGetter.apply(NORMAL_LED_MODEL).resolveParents(modelGetter);
        modelGetter.apply(NEAR_CAPACITY_LED_MODEL).resolveParents(modelGetter);
        modelGetter.apply(FULL_LED_MODEL).resolveParents(modelGetter);
        RefinedStorageClientApi.INSTANCE.getDiskModels().forEach(diskModel -> ((UnbakedModel)modelGetter.apply((ResourceLocation)diskModel)).resolveParents(modelGetter));
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        return new PortableGridBakedModel(Objects.requireNonNull(baker.bake(INACTIVE_MODEL, modelState, spriteGetter)), new RotationTranslationModelBaker(modelState, baker, spriteGetter, ACTIVE_MODEL), new RotationTranslationModelBaker(modelState, baker, spriteGetter, INACTIVE_MODEL), new DiskModelBaker(modelState, baker, spriteGetter), new DiskLedBakers(new RotationTranslationModelBaker(modelState, baker, spriteGetter, INACTIVE_LED_MODEL), new RotationTranslationModelBaker(modelState, baker, spriteGetter, NORMAL_LED_MODEL), new RotationTranslationModelBaker(modelState, baker, spriteGetter, NEAR_CAPACITY_LED_MODEL), new RotationTranslationModelBaker(modelState, baker, spriteGetter, FULL_LED_MODEL)));
    }
}

