/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.experience.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.experience.ExperienceDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.particles.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ExperienceGemWidget
extends AbstractDescriptionWidget
implements ITickingWidget,
IHoverableWidget {
    private final ExperienceDescriptionScreen screen;
    private final String source;
    private float scale = 1.0f;
    private float scaleOld = 1.0f;

    public ExperienceGemWidget(int x, int y, ExperienceDescriptionScreen screen, String source) {
        super(x, y, 32, 47);
        this.screen = screen;
        this.source = source;
    }

    @Override
    public void onPress() {
        if (this.screen.getSelectedSource().equals(this.source)) {
            return;
        }
        this.screen.setSelectedSource(this.source);
        this.screen.rebuildWidgets();
        for (Renderable entry : this.screen.renderables) {
            if (!(entry instanceof ExperienceGemWidget)) continue;
            ExperienceGemWidget gem = (ExperienceGemWidget)entry;
            if (!gem.source.equals(this.source)) continue;
            gem.scale = this.scale;
            gem.scaleOld = this.scaleOld;
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = this.screen.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        ItemStack stack = this.screen.getStack();
        PoseStack poseStack = guiGraphics.pose();
        LevelingSourceData sourceData = relic.getLevelingSourcesData().getSources().get(this.source);
        boolean isUnlocked = relic.isLevelingSourceUnlocked(stack, this.source);
        poseStack.pushPose();
        RenderSystem.enableBlend();
        float partialTicks = this.minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        float lerpedScale = Mth.lerp((float)partialTicks, (float)this.scaleOld, (float)this.scale);
        poseStack.scale(lerpedScale, lerpedScale, lerpedScale);
        poseStack.translate(((float)this.getX() + (float)this.width / 2.0f) / lerpedScale, ((float)this.getY() + (float)this.height / 2.0f) / lerpedScale, 0.0f);
        String shape = sourceData.getShape().name().toLowerCase(Locale.ROOT);
        float color = (float)((double)1.05f + Math.sin((float)(player.tickCount + this.source.length() * 10) * 0.2f) * (double)0.1f);
        if (isUnlocked) {
            GUIRenderer.begin(sourceData.getIcon().apply(stack), poseStack).pos(0.0f, -1.0f).color(color, color, color, 1.0f).end();
        } else {
            GUIRenderer.begin(DescriptionTextures.SMALL_CARD_LOCK_BACKGROUND, poseStack).pos(0.0f, -1.0f).end();
        }
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/experience/gems/" + shape + "/" + sourceData.getColor().name().toLowerCase(Locale.ROOT) + ".png")), poseStack).end();
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/experience/gems/" + shape + "/frame_" + (isUnlocked ? "unlocked" : "locked") + ".png")), poseStack).end();
        RenderSystem.disableBlend();
        MutableComponent title = Component.literal((String)(isUnlocked ? String.valueOf(relic.getLevelingSourceLevel(stack, this.source)) : "?")).withStyle(ChatFormatting.BOLD);
        float textScale = 0.5f;
        poseStack.scale(textScale, textScale, textScale);
        guiGraphics.drawString(this.minecraft.font, (Component)title, -((this.width + 1) / 2) - this.minecraft.font.width((FormattedText)title) / 2 + 16, -(this.height / 2) + 40, isUnlocked ? 16769656 : 12037849, true);
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        float maxScale = 1.15f;
        float minScale = 1.0f;
        RandomSource random = this.minecraft.player.getRandom();
        this.scaleOld = this.scale;
        if (this.scale > maxScale) {
            this.scale = Math.max(minScale, this.scale - 0.01f);
        }
        if (this.isHovered()) {
            if (this.minecraft.player.tickCount % 3 == 0) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), this.getX() + random.nextInt(this.width), this.getY() - 1, 1.0f + random.nextFloat() * 0.5f, 100 + random.nextInt(50)));
            }
            if (this.scale < maxScale) {
                this.scale = Math.min(maxScale, this.scale + 0.04f);
            }
        } else if (this.scale > minScale) {
            this.scale = Math.max(minScale, this.scale - 0.03f);
        }
    }

    @Override
    public boolean isLocked() {
        return this.screen.getSelectedSource().equals(this.source);
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = this.screen.stack;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        LevelingSourceData data = relic.getLevelingSourceData(this.source);
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        MutableComponent title = Component.translatableWithFallback((String)(data.getTranslationPath().apply(stack) + ".title"), (String)this.source);
        int maxWidth = 110;
        int renderWidth = Math.min(this.minecraft.font.width((FormattedText)title.withStyle(ChatFormatting.BOLD)) / 2 + 4, maxWidth);
        ArrayList<MutableComponent> entries = new ArrayList<MutableComponent>();
        entries.add(Component.literal((String)" "));
        int requiredLevel = data.getRequiredLevel();
        String requiredAbility = data.getRequiredAbility();
        if (relic.getRelicLevel(this.screen.stack) < requiredLevel) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.gem.low_level", (Object[])new Object[]{Component.literal((String)String.valueOf(requiredLevel)).withStyle(ChatFormatting.BOLD)})));
        } else if (!requiredAbility.isEmpty() && !relic.isAbilityUnlocked(stack, requiredAbility)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.gem.locked_ability")));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 4, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = tooltip.size() * 5;
        int y = this.getHeight() / 2;
        float partialTicks = this.minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        float lerpedScale = Mth.lerp((float)partialTicks, (float)this.scaleOld, (float)this.scale);
        poseStack.scale(lerpedScale, lerpedScale, lerpedScale);
        poseStack.translate(((float)this.getX() + (float)this.getWidth() / 2.0f) / lerpedScale, ((float)this.getY() + (float)this.getHeight() / 2.0f) / lerpedScale, 0.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, -((renderWidth + 19) / 2), y);
        int yOff = 0;
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        if (!relic.isLevelingSourceUnlocked(stack, this.source)) {
            title = ScreenUtils.stylizeWithReplacement(title, 1.0, Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(10354864), (long)this.source.length());
            RandomSource random = this.minecraft.player.getRandom();
            float shakeX = MathUtils.randomFloat(random) * 0.5f;
            float shakeY = MathUtils.randomFloat(random) * 0.5f;
            poseStack.translate(shakeX, shakeY, 0.0f);
        } else {
            title.withStyle(ChatFormatting.BOLD);
        }
        guiGraphics.drawString(this.minecraft.font, (Component)title, -(this.minecraft.font.width((FormattedText)title) / 2), (y + yOff + 9) * 2, 6696723, false);
        poseStack.popPose();
        for (FormattedCharSequence entry : tooltip) {
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.minecraft.font, entry, -(this.minecraft.font.width(entry) / 2), (y + yOff + 9) * 2, 6696723, false);
            yOff += 5;
            poseStack.popPose();
        }
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (!this.isLocked()) {
            super.playDownSound(handler);
        }
    }
}

