/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import net.minecraft.core.Position;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import reliquary.entity.ConcussiveExplosion;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;

public class HolyHandGrenade
extends ThrowableProjectile
implements ItemSupplier {
    private int count = 0;
    private Player playerThrower;

    public HolyHandGrenade(EntityType<HolyHandGrenade> entityType, Level level) {
        super(entityType, level);
    }

    public HolyHandGrenade(Level level, Player player, String customName) {
        super(ModEntities.HOLY_HAND_GRENADE.get(), (LivingEntity)player, level);
        this.playerThrower = player;
        this.setCustomName((Component)Component.literal((String)customName));
    }

    public HolyHandGrenade(Level level, Position position) {
        super(ModEntities.HOLY_HAND_GRENADE.get(), position.x(), position.y(), position.z(), level);
    }

    protected double getDefaultGravity() {
        return 0.03f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.count == 2) {
            for (int particles = 0; particles < this.random.nextInt(2) + 1; ++particles) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.opaque((int)0)), this.getX() + this.level().random.nextDouble(), this.getY() + this.level().random.nextDouble(), this.getZ() + this.level().random.nextDouble(), 0.0, 0.0, 0.0);
            }
            this.count = 0;
        } else {
            ++this.count;
        }
    }

    protected void onHit(HitResult result) {
        if (this.level().isClientSide) {
            return;
        }
        if (this.tickCount > 3 || result.getType() != HitResult.Type.ENTITY || !(((EntityHitResult)result).getEntity() instanceof Player)) {
            ConcussiveExplosion.grenadeConcussiveExplosion((Entity)this, this.playerThrower, this.position());
        }
        this.discard();
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)ModItems.HOLY_HAND_GRENADE.get());
    }
}

