/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.charm;

import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.ScribbleRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class EmblemOfDefenseItem
extends ScribbleRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"repulse").stat(StatData.builder((String)"cooldown").initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.0335).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"count").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.7).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"repulse").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-2251484).borderBottom(-2251484).textured(true).build()).beams(BeamsData.builder().startColor(-1100904).endColor(12784992).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || this.getTime(stack) == 0) {
            return;
        }
        RandomSource random = player.getRandom();
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        this.consumeTime(stack, 1);
        DeferredHolder tag = DataComponentRegistry.TIME;
        Optional curiosInv = CuriosApi.getCuriosInventory((LivingEntity)player);
        int relicCount = curiosInv.map(inventory -> inventory.findCurios(stack1 -> stack1.is(stack.getItem()) && stack1.has((Supplier)tag) && (Integer)stack1.get((Supplier)tag) > 0).size()).orElse(0);
        if (this.getTime(stack) == 0 && relicCount <= 1) {
            for (int i = 0; i < 100; ++i) {
                double angle = Math.PI * 2 * (double)i / 100.0;
                double x = player.getX() + 1.0 * Math.cos(angle);
                double z = player.getZ() + 1.0 * Math.sin(angle);
                level.playSound(null, (Entity)player, SoundEvents.ILLUSIONER_PREPARE_MIRROR, SoundSource.PLAYERS, 0.25f, 0.9f + random.nextFloat() * 0.2f);
                level.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(50 + random.nextInt(100), 0, 150 + random.nextInt(100)), (float)0.3f, (int)60, (float)0.95f), x, player.getY() + (double)(player.getBbHeight() / 2.0f), z, 1, 0.0, 0.1, 0.0, 0.1);
            }
        }
    }

    public void consumeTime(ItemStack stack, int time) {
        this.setTime(stack, this.getTime(stack) - time);
    }

    public void setTime(ItemStack stack, int time) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(time, 0));
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    @Override
    public int getCountGlyphInItem(ItemStack stack) {
        return (int)Math.round(this.getStatValue(stack, "repulse", "count"));
    }

    @EventBusSubscriber
    public static class EmblemOfDefenseEvent {
        @SubscribeEvent
        public static void onAttacked(LivingDamageEvent.Post event) {
            LivingEntity source;
            Player player;
            Object object = event.getEntity();
            if (!(object instanceof Player) || (player = (Player)object).getCommandSenderWorld().isClientSide() || !((object = event.getSource().getEntity()) instanceof LivingEntity) || (source = object).getUUID().equals(player.getUUID())) {
                return;
            }
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.EMBLEM_OF_DEFENSE.value()))) {
                EmblemOfDefenseItem relic;
                Item item = stack.getItem();
                if (!(item instanceof EmblemOfDefenseItem) || (relic = (EmblemOfDefenseItem)item).getTime(stack) != 0 || !relic.isAbilityUnlocked(stack, "repulse")) continue;
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                relic.setTime(stack, (int)(relic.getStatValue(stack, "repulse", "cooldown") * 20.0));
                relic.onAutoCastedSpell(player, source, stack, new Color(100, 0, 255));
            }
        }
    }
}

