/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.head;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.RANDataComponentRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class HornOfWildHunterItem
extends NouveauRelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"summoner").stat(StatData.builder((String)"damage").initialValue(1.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"summoner").initialValue(1).gem(GemShape.SQUARE, GemColor.RED).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-10456960).borderBottom(-10456960).textured(true).build()).beams(BeamsData.builder().startColor(-201753).endColor(10063756).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !this.isAbilityUnlocked(stack, "summoner")) {
            return;
        }
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        ArrayList<UUID> livingWolves = new ArrayList<UUID>(this.getWolves(stack));
        for (int i = livingWolves.size() - 1; i >= 0; --i) {
            Entity wolf = level.getEntity(livingWolves.get(i));
            if (wolf != null && !(player.distanceTo(wolf) > 64.0f)) continue;
            livingWolves.remove(i);
        }
        if (livingWolves.size() < 2 && (player.onGround() || player.isInLiquid()) && level.isLoaded(player.blockPosition())) {
            RandomSource random = player.getRandom();
            if (this.getWolves(stack).isEmpty()) {
                level.playSound(null, (Entity)player, SoundEvents.WOLF_HOWL, SoundSource.PLAYERS, 0.15f, 0.9f + random.nextFloat() * 0.2f);
            }
            BlockPos position = this.getPosition(random, player, (Level)level);
            Wolf wolf = new Wolf(EntityType.WOLF, (Level)level);
            wolf.setOwnerUUID(player.getUUID());
            wolf.setPos((double)position.getX() + 0.5, (double)position.getY(), (double)position.getZ() + 0.5);
            wolf.setTame(true, true);
            wolf.setAggressive(true);
            wolf.setInvulnerable(true);
            wolf.getPersistentData().putString("summon", "spawned");
            wolf.setSilent(true);
            level.addFreshEntity((Entity)wolf);
            livingWolves.add(wolf.getUUID());
            EntityUtils.applyAttribute((LivingEntity)wolf, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (float)((int)MathUtils.round((double)this.getStatValue(stack, "summoner", "damage"), (int)0)), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
            EntityUtils.applyAttribute((LivingEntity)wolf, (ItemStack)stack, (Holder)Attributes.SCALE, (float)-0.25f, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            Vec3 startPos = new Vec3((double)position.getX() + 0.5, (double)((float)position.getY() + wolf.getBbHeight() / 2.0f), (double)position.getZ() + 0.5);
            Vec3 endPos = player.position();
            int particleCount = 10;
            for (int j = 0; j <= particleCount; ++j) {
                double t = (double)j / (double)particleCount;
                level.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(150 + random.nextInt(100), 150 + random.nextInt(100), 150 + random.nextInt(100)), (float)0.3f, (int)40, (float)0.9f), Mth.lerp((double)t, (double)startPos.x, (double)endPos.x), Mth.lerp((double)t, (double)startPos.y, (double)endPos.y), Mth.lerp((double)t, (double)startPos.z, (double)endPos.z), 10, 0.1, 0.1, 0.1, 0.01);
            }
        }
        this.setWolves(stack, livingWolves);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.25f, (float)0.75f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-7.0f, (float)-5.0f, (float)0.7854f, (float)-0.3927f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, -2.0f, -0.75f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-0.5f, -2.0f, -0.75f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9973f, (float)-9.7867f, (float)-6.2005f, (float)0.0873f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"head"});
    }

    public BlockPos getPosition(RandomSource random, Player player, Level level) {
        double angle = random.nextDouble() * 2.0 * Math.PI;
        int radius = 1 + random.nextInt(2);
        int offsetX = (int)Math.round(Math.cos(angle) * (double)radius);
        int offsetZ = (int)Math.round(Math.sin(angle) * (double)radius);
        BlockPos spawnPos = player.blockPosition().offset(offsetX, 0, offsetZ);
        for (int i = 0; i < 5 && (this.hasCollision(level, spawnPos) || this.hasCollision(level, spawnPos.above())); ++i) {
            spawnPos = spawnPos.above();
        }
        if (this.hasCollision(level, spawnPos) || this.hasCollision(level, spawnPos.above())) {
            spawnPos = player.blockPosition();
        }
        return spawnPos;
    }

    private boolean hasCollision(Level level, BlockPos pos) {
        return level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).max(Direction.Axis.Y) >= 0.25;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || newStack.getItem() == stack.getItem()) {
            return;
        }
        for (int i = 0; i < this.getWolves(stack).size(); ++i) {
            Entity entity = ((ServerLevel)player.getCommandSenderWorld()).getEntity(this.getWolves(stack).get(i));
            if (entity == null) continue;
            entity.discard();
        }
    }

    public void setWolves(ItemStack stack, List<UUID> list) {
        stack.set(RANDataComponentRegistry.WOLVES, list);
    }

    public List<UUID> getWolves(ItemStack stack) {
        return (List)stack.getOrDefault(RANDataComponentRegistry.WOLVES, new ArrayList());
    }

    @EventBusSubscriber
    public static class HornsOfWildHunterEvent {
        @SubscribeEvent
        public static void onWolfAttacking(LivingDamageEvent.Post event) {
            Wolf wolf;
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof Wolf && (wolf = (Wolf)entity).getPersistentData().getString("summon").equals("spawned") && (entity = wolf.getOwner()) instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.HORN_OF_THE_WILD_HUNTER.value()));
            Item item = stack.getItem();
            if (!(item instanceof HornOfWildHunterItem)) {
                return;
            }
            HornOfWildHunterItem relic = (HornOfWildHunterItem)item;
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
        }

        @SubscribeEvent
        public static void onAppointmentTarget(LivingChangeTargetEvent event) {
            LivingEntity newTarget;
            Wolf wolf;
            block7: {
                block6: {
                    Player player;
                    block5: {
                        block4: {
                            LivingEntity livingEntity = event.getEntity();
                            if (!(livingEntity instanceof Wolf) || !(wolf = (Wolf)livingEntity).getPersistentData().getString("summon").equals("spawned") || !((livingEntity = wolf.getOwner()) instanceof Player)) break block4;
                            player = (Player)livingEntity;
                            if (wolf.getTarget() == null) break block5;
                        }
                        return;
                    }
                    ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.HORN_OF_THE_WILD_HUNTER.value()));
                    newTarget = event.getOriginalAboutToBeSetTarget();
                    Item item = stack.getItem();
                    if (!(item instanceof HornOfWildHunterItem)) break block6;
                    HornOfWildHunterItem relic = (HornOfWildHunterItem)item;
                    if (newTarget != null && !(newTarget.distanceTo((Entity)wolf) <= 16.0f)) break block7;
                }
                return;
            }
            wolf.lookAt(EntityAnchorArgument.Anchor.EYES, newTarget.getPosition(1.0f));
            wolf.teleportTo(newTarget.getX(), newTarget.getY() + 1.0, newTarget.getZ());
        }

        @SubscribeEvent
        public static void onDogChangeDimension(EntityTravelToDimensionEvent event) {
            Wolf wolf;
            Object object = event.getEntity();
            if (!(object instanceof Wolf) || (wolf = (Wolf)object).getCommandSenderWorld().isClientSide() || !wolf.isTame() || !((object = wolf.getOwner()) instanceof Player)) {
                return;
            }
            Player player = (Player)object;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.HORN_OF_THE_WILD_HUNTER.value()))) {
                HornOfWildHunterItem relic;
                Item item = stack.getItem();
                if (!(item instanceof HornOfWildHunterItem) || (relic = (HornOfWildHunterItem)item).getWolves(stack).isEmpty()) {
                    return;
                }
                for (UUID wolfUUID : relic.getWolves(stack)) {
                    Entity oldWolf = ((ServerLevel)player.getCommandSenderWorld()).getEntity(wolfUUID);
                    if (oldWolf == null) continue;
                    oldWolf.discard();
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player.getCommandSenderWorld().isClientSide()) {
                return;
            }
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            List stacks = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.HORN_OF_THE_WILD_HUNTER.value()));
            if (stacks.isEmpty()) {
                return;
            }
            for (ItemStack stack : stacks) {
                HornOfWildHunterItem relic;
                Item item = stack.getItem();
                if (!(item instanceof HornOfWildHunterItem) || (relic = (HornOfWildHunterItem)item).getWolves(stack).isEmpty()) {
                    return;
                }
                for (UUID wolfUUID : relic.getWolves(stack)) {
                    Entity oldWolf = level.getServer().getLevel(event.getFrom()).getEntity(wolfUUID);
                    if (oldWolf == null) continue;
                    oldWolf.discard();
                }
            }
        }
    }
}

