/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.ring;

import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IntangibleAirTile;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIntangible;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.PredicateType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.hurts.sskirillss.relics.utils.data.WorldPosition;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

public class RingOfTheSpectralWalkerItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"spectral").active(CastData.builder().type(CastType.CYCLICAL).predicate("teleport", PredicateType.CAST, (player, stack) -> new ManaCap((LivingEntity)player).getCurrentMana() >= this.getManacostInTick((ItemStack)stack)).build()).stat(StatData.builder((String)"consumption").initialValue(75.0, 50.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"spectral").initialValue(1).gem(GemShape.SQUARE, GemColor.BLUE).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-13816488).borderBottom(-13816488).textured(true).build()).beams(BeamsData.builder().startColor(-15477787).endColor(7570612).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (!ability.equals("spectral") || player.getCommandSenderWorld().isClientSide()) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        BlockPos playerBlockPos = player.blockPosition();
        BlockState playerBlockState = level.getBlockState(playerBlockPos);
        BlockState playerBlockStateAbove = level.getBlockState(playerBlockPos.above());
        double currentMana = new ManaCap((LivingEntity)player).getCurrentMana();
        if (stage == CastStage.TICK && currentMana >= this.getManacostInTick(stack)) {
            if (player.tickCount % 20 == 0) {
                this.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            if (!(!playerBlockState.isAir() && playerBlockState.getFluidState().isEmpty() || !playerBlockStateAbove.isAir() && playerBlockStateAbove.getFluidState().isEmpty() || playerBlockStateAbove.is((Block)BlockRegistry.INTANGIBLE_AIR.get()))) {
                this.setPosition(stack, new WorldPosition((Entity)player));
            }
            player.fallDistance = 0.0f;
            if (playerBlockStateAbove.is((Block)BlockRegistry.INTANGIBLE_AIR.get())) {
                Vec3 vec = player.getLookAngle().scale(0.4);
                if (vec.y >= 0.2) {
                    vec = vec.scale(1.9);
                }
                NetworkHandler.sendToClient((CustomPacketPayload)new PacketPlayerMotion(vec.x(), vec.y(), vec.z()), (ServerPlayer)((ServerPlayer)player));
                player.startAutoSpinAttack(5, 0.0f, ItemStack.EMPTY);
            }
            RandomSource random = level.getRandom();
            for (VoxelShape voxelShape : level.getBlockCollisions((Entity)player, player.getBoundingBox().inflate(0.5).expandTowards(player.getKnownMovement().normalize()))) {
                AABB box = voxelShape.bounds();
                BlockPos blockPos = new BlockPos((int)box.minX, (int)box.minY, (int)box.minZ);
                BlockState state = level.getBlockState(blockPos);
                EffectIntangible intangible = EffectIntangible.INSTANCE;
                if (level.getBlockEntity(blockPos) != null || state.isAir() || state.getBlock() == Blocks.BEDROCK || !intangible.canBlockBeHarvested(new SpellStats.Builder().build(), level, blockPos) || !BlockUtil.destroyRespectsClaim((LivingEntity)intangible.getPlayer((LivingEntity)player, (ServerLevel)level), (Level)level, (BlockPos)blockPos)) continue;
                level.setBlockAndUpdate(blockPos, BlockRegistry.INTANGIBLE_AIR.defaultBlockState());
                IntangibleAirTile tile = (IntangibleAirTile)level.getBlockEntity(blockPos);
                if (tile == null) {
                    return;
                }
                tile.stateID = Block.getId((BlockState)state);
                tile.maxLength = level.getBlockState(blockPos.above()).isAir() ? 5 : 20;
                ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(100 + random.nextInt(156), random.nextInt(100 + random.nextInt(156)), random.nextInt(100 + random.nextInt(156))), (float)0.2f, (int)60, (float)0.95f), player.getX(), player.getY() + (double)0.2f, player.getZ(), 3, 0.3, 0.1, 0.3, 0.1);
            }
        } else if (!playerBlockStateAbove.getCollisionShape((BlockGetter)level, playerBlockPos.above()).isEmpty() || playerBlockState.is((Block)BlockRegistry.INTANGIBLE_AIR.get()) || playerBlockStateAbove.is((Block)BlockRegistry.INTANGIBLE_AIR.get())) {
            Vec3 targetPos = this.getPosition(stack).getPos();
            player.teleportTo(targetPos.x() + 0.5, targetPos.y() + (double)player.getBbHeight(), targetPos.z() + 0.5);
            level.playSound(null, (Entity)player, SoundEvents.ARMADILLO_DEATH, SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !this.isAbilityTicking(stack, "spectral")) {
            return;
        }
        ManaCap mana = new ManaCap((LivingEntity)player);
        mana.removeMana(this.getManacostInTick(stack));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (newStack.getItem() == stack.getItem()) {
            return;
        }
        this.setPosition(stack, null);
    }

    public double getManacostInTick(ItemStack stack) {
        return this.getStatValue(stack, "spectral", "consumption") / 20.0;
    }

    public void setPosition(ItemStack stack, WorldPosition val) {
        stack.set((Supplier)DataComponentRegistry.WORLD_POSITION, (Object)val);
    }

    public WorldPosition getPosition(ItemStack stack) {
        return (WorldPosition)stack.get((Supplier)DataComponentRegistry.WORLD_POSITION);
    }

    @EventBusSubscriber
    public static class RingOfTheSpectralWalkerEvent {
        @SubscribeEvent
        public static void onLivingDeath(LivingIncomingDamageEvent event) {
            RingOfTheSpectralWalkerItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.RING_OF_THE_SPECTRAL_WALKER.value()));
            Item item = stack.getItem();
            if (!(item instanceof RingOfTheSpectralWalkerItem && (relic = (RingOfTheSpectralWalkerItem)item).isAbilityTicking(stack, "spectral") && event.getSource().is(DamageTypes.IN_WALL))) {
                return;
            }
            event.setCanceled(true);
        }
    }
}

