/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.mixin;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.back.IllusionistsMantleItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityDummy.class})
public abstract class EntityDummyMixin
extends PathfinderMob
implements ISummon {
    protected EntityDummyMixin(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onEntityInside(CallbackInfo ci) {
        EntityDummy dummy = (EntityDummy)this;
        if (dummy.getCommandSenderWorld().isClientSide() || dummy.getOwnerUUID() == null || !dummy.getPersistentData().getBoolean("SpawnedFromRelic")) {
            return;
        }
        ServerLevel level = (ServerLevel)dummy.getCommandSenderWorld();
        Player entity = level.getPlayerByUUID(dummy.getOwnerUUID());
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.ILLUSIONISTS_MANTLE.value()));
        if (!stack.isEmpty()) {
            return;
        }
        dummy.discard();
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        EntityDummy dummy = (EntityDummy)this;
        if (dummy.getCommandSenderWorld().isClientSide() || dummy.getOwnerUUID() == null || !dummy.getPersistentData().getBoolean("SpawnedFromRelic")) {
            return;
        }
        ServerLevel level = (ServerLevel)dummy.getCommandSenderWorld();
        Player entity = level.getPlayerByUUID(dummy.getOwnerUUID());
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.ILLUSIONISTS_MANTLE.value()));
        Item item = stack.getItem();
        if (!(item instanceof IllusionistsMantleItem)) {
            return;
        }
        IllusionistsMantleItem relic = (IllusionistsMantleItem)item;
        relic.removeEntities(stack, dummy.getUUID());
    }
}

