/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.mixin;

import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.head.HornOfWildHunterItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Wolf.class})
public class WolfMixin {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onEntityInside(CallbackInfo ci) {
        Wolf wolf = (Wolf)this;
        LivingEntity livingEntity = wolf.getOwner();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        List stacks = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.HORN_OF_THE_WILD_HUNTER.value()));
        boolean hasSummon = wolf.getPersistentData().getString("summon").equals("spawned");
        if (!stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                Item item = stack.getItem();
                if (!(item instanceof HornOfWildHunterItem)) continue;
                HornOfWildHunterItem relic = (HornOfWildHunterItem)item;
                if (!hasSummon || relic.getWolves(stack).contains(wolf.getUUID())) continue;
                wolf.discard();
            }
        } else if (hasSummon) {
            wolf.discard();
        }
    }
}

